/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.crf;

import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.crf.FeatureTemplate;
import com.mayabot.nlp.segment.crf.FeatureTemplateElement;
import com.mayabot.nlp.segment.crf.FeatureTemplateElementType;
import com.mayabot.nlp.segment.crf.FeatureTemplateGroup;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J8\u0010\u000f\u001a\u00020\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a8\u0006\u0015"}, d2={"Lcom/mayabot/nlp/segment/crf/NerCrfFeature;", "", "()V", "extFeature", "", "sentence", "", "Lcom/mayabot/nlp/segment/WordTerm;", "position", "", "sbFeature", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ft", "Lcom/mayabot/nlp/segment/crf/FeatureTemplate;", "extractFeatureVector", "Lcom/mayabot/nlp/hppc/IntArrayList;", "features", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "featureTemplateGroup", "Lcom/mayabot/nlp/segment/crf/FeatureTemplateGroup;", "mynlp-segment"})
public final class NerCrfFeature {
    public static final NerCrfFeature INSTANCE;

    @NotNull
    public final IntArrayList extractFeatureVector(@NotNull List<WordTerm> sentence, int position, @NotNull FeatureSet features, @NotNull FeatureTemplateGroup featureTemplateGroup, @NotNull StringBuilder sbFeature) {
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull((Object)features, (String)"features");
        Intrinsics.checkParameterIsNotNull((Object)featureTemplateGroup, (String)"featureTemplateGroup");
        Intrinsics.checkParameterIsNotNull((Object)sbFeature, (String)"sbFeature");
        IntArrayList vector = new IntArrayList(featureTemplateGroup.getSize() + 1);
        StringsKt.clear((StringBuilder)sbFeature);
        Iterator<FeatureTemplate> iterator = featureTemplateGroup.getList().iterator();
        while (iterator.hasNext()) {
            FeatureTemplate ft;
            FeatureTemplate featureTemplate = ft = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)featureTemplate, (String)"ft");
            this.extFeature(sentence, position, sbFeature, featureTemplate);
            int id = features.featureId(sbFeature);
            if (id != -1) {
                vector.add(id);
            }
            StringsKt.clear((StringBuilder)sbFeature);
        }
        vector.add(0);
        return vector;
    }

    private final void extFeature(List<WordTerm> sentence, int position, StringBuilder sbFeature, FeatureTemplate ft) {
        int senLen = sentence.size();
        for (FeatureTemplateElement x : ft.getList()) {
            FeatureTemplateElementType type = x.getType();
            if (type == FeatureTemplateElementType.String) {
                sbFeature.append(x.getValue());
                continue;
            }
            int offset = x.getOffset() + position;
            int col = x.getCol();
            if (offset < 0) {
                sbFeature.append(FeatureTemplateGroup.Companion.getBOS()[-(offset + 1)]);
                continue;
            }
            if (offset >= senLen) {
                sbFeature.append(FeatureTemplateGroup.Companion.getEOS()[offset - senLen]);
                continue;
            }
            sbFeature.append(col == 0 ? sentence.get((int)offset).word : sentence.get(offset).getNatureString());
        }
    }

    private NerCrfFeature() {
    }

    static {
        NerCrfFeature nerCrfFeature;
        INSTANCE = nerCrfFeature = new NerCrfFeature();
    }
}

