/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.cws;

import com.mayabot.nlp.segment.cws.CWSEvaluate;
import com.mayabot.nlp.segment.cws.CWSPerceptron;
import com.mayabot.nlp.utils.CharNormUtils;
import com.mayabot.t.google.common.base.Splitter;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/mayabot/nlp/segment/cws/CWSEvaluate;", "", "()V", "evaluate", "", "evaluateSample", "", "", "segmenter", "Lcom/mayabot/nlp/segment/cws/CWSPerceptron;", "mynlp-segment"})
public final class CWSEvaluate {
    public static final CWSEvaluate INSTANCE;

    @NotNull
    public final double[] evaluate(@NotNull List<String> evaluateSample2, @NotNull CWSPerceptron segmenter) {
        PrintStream printStream;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull(evaluateSample2, (String)"evaluateSample");
        Intrinsics.checkParameterIsNotNull((Object)segmenter, (String)"segmenter");
        int goldTotal = 0;
        int predTotal = 0;
        int correct = 0;
        Splitter splitter = Splitter.on("\ufe4d").omitEmptyStrings();
        System.out.print("Evaluating 0%");
        long t1 = System.currentTimeMillis();
        int count = 0;
        for (String line : evaluateSample2) {
            String string;
            List<String> wordArray = splitter.splitToList(CharNormUtils.convert(line));
            goldTotal += wordArray.size();
            List<String> list = wordArray;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"wordArray");
            String text = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            List<String> predArray = segmenter.decodeToWordList(text);
            predTotal += predArray.size();
            int goldIndex = 0;
            int predIndex = 0;
            int goldLen = 0;
            int predLen = 0;
            while (goldIndex < wordArray.size() && predIndex < predArray.size()) {
                if (goldLen == predLen) {
                    if (Intrinsics.areEqual((Object)wordArray.get(goldIndex), (Object)predArray.get(predIndex))) {
                        ++correct;
                        goldLen += wordArray.get(goldIndex).length();
                        predLen += wordArray.get(goldIndex).length();
                        ++goldIndex;
                        ++predIndex;
                        continue;
                    }
                    goldLen += wordArray.get(goldIndex).length();
                    predLen += predArray.get(predIndex).length();
                    ++goldIndex;
                    ++predIndex;
                    continue;
                }
                if (goldLen < predLen) {
                    goldLen += wordArray.get(goldIndex).length();
                    ++goldIndex;
                    continue;
                }
                predLen += predArray.get(predIndex).length();
                ++predIndex;
            }
            if (++count % 2000 != 0) continue;
            String string2 = "%.2f";
            Object[] objectArray = new Object[]{(double)count * 100.0 / (double)evaluateSample2.size()};
            charSequence = new StringBuilder().append("\rEvaluating ");
            printStream = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
            printStream.print(((StringBuilder)charSequence).append(string).append('%').toString());
        }
        evaluate.1 prf$ = evaluate.1.INSTANCE;
        double[] result = prf$.invoke(goldTotal, predTotal, correct);
        System.out.print("\r");
        long t2 = System.currentTimeMillis();
        String string = "\u6b63\u786e\u7387(P) %.2f , \u53ec\u56de\u7387(R) %.2f , F1 %.2f";
        Object[] objectArray = new Object[]{result[0], result[1], result[2]};
        printStream = System.out;
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
        charSequence = string3;
        printStream.println((String)charSequence);
        string = "Evaluate use time " + (t2 - t1) + " ms";
        System.out.println((Object)string);
        return result;
    }

    private CWSEvaluate() {
    }

    static {
        CWSEvaluate cWSEvaluate;
        INSTANCE = cWSEvaluate = new CWSEvaluate();
    }
}

