/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.cws;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.perceptron.TrainSample;
import com.mayabot.nlp.segment.cws.CWSPerceptronFeature;
import com.mayabot.nlp.segment.cws.CWSPerceptronSample;
import com.mayabot.nlp.utils.CharNormUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/mayabot/nlp/segment/cws/CWSPerceptron;", "", "model", "Lcom/mayabot/nlp/perceptron/Perceptron;", "(Lcom/mayabot/nlp/perceptron/Perceptron;)V", "getModel", "()Lcom/mayabot/nlp/perceptron/Perceptron;", "compress", "", "ratio", "", "threshold", "decode", "", "sentence", "", "convert", "", "decodeToWordList", "", "", "learn", "save", "dir", "Ljava/io/File;", "Companion", "mynlp-segment"})
public final class CWSPerceptron {
    @NotNull
    private final Perceptron model;
    public static final int B = 0;
    public static final int M = 1;
    public static final int E = 2;
    public static final int S = 3;
    @NotNull
    private static final List<String> tagList;
    public static final Companion Companion;

    public final void save(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        dir.mkdirs();
        this.model.save(dir);
    }

    public final void compress(double ratio, double threshold) {
        this.model.compress(ratio, threshold);
    }

    public final void learn(@NotNull String learn2) {
        Intrinsics.checkParameterIsNotNull((Object)learn2, (String)"learn");
        String sentence = StringsKt.replace$default((String)learn2, (String)" ", (String)"\ufe4d", (boolean)false, (int)4, null);
        FeatureSet featureSet = this.model.featureSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)featureSet, (String)"model.featureSet()");
        int id = CWSPerceptronSample.INSTANCE.forOnlineLearn(sentence, featureSet);
        this.model.makeSureParameter(id);
        FeatureSet featureSet2 = this.model.featureSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)featureSet2, (String)"model.featureSet()");
        TrainSample sample = CWSPerceptronSample.INSTANCE.sentenceToSample(sentence, featureSet2);
        this.model.updateForOnlineLearn(sample);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> decodeToWordList(@NotNull String sentence) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        ArrayList result = new ArrayList();
        String string = sentence;
        CWSPerceptron cWSPerceptron = this;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        int[] decode = cWSPerceptron.decode(cArray2, true);
        int p = 0;
        int n = 0;
        int n2 = decode.length;
        while (n < n2) {
            void i;
            int f = decode[i];
            if (f == 3 || f == 2) {
                Collection collection = result;
                String string2 = sentence;
                void var10_15 = i + true;
                String string3 = string2.substring(p, (int)var10_15);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string2 = string3;
                collection.add(string2);
                p = i + true;
            }
            ++i;
        }
        if (p < sentence.length()) {
            Collection collection = result;
            String string4 = sentence;
            int n3 = sentence.length();
            String string5 = string4.substring(p, n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string4 = string5;
            collection.add(string4);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] decode(@NotNull char[] sentence, boolean convert) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        if (convert) {
            CharNormUtils.convert(sentence);
        }
        FastStringBuilder buffer = new FastStringBuilder(4);
        ArrayList featureList = new ArrayList(sentence.length);
        int n = 0;
        int n2 = sentence.length;
        while (n < n2) {
            void i;
            Collection collection = featureList;
            int n3 = sentence.length;
            FeatureSet featureSet = this.model.featureSet();
            Intrinsics.checkExpressionValueIsNotNull((Object)featureSet, (String)"model.featureSet()");
            IntArrayList intArrayList = CWSPerceptronFeature.INSTANCE.extractFeatureVector(sentence, n3, (int)i, featureSet, buffer);
            collection.add(intArrayList);
            ++i;
        }
        int[] nArray = this.model.decode(featureList);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray, (String)"model.decode(featureList)");
        return nArray;
    }

    @NotNull
    public final Perceptron getModel() {
        return this.model;
    }

    public CWSPerceptron(@NotNull Perceptron model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this.model = model;
    }

    static {
        Companion = new Companion(null);
        tagList = CollectionsKt.listOf((Object[])new String[]{"B", "M", "E", "S"});
    }

    @NotNull
    public static final List<String> getTagList() {
        Companion companion = Companion;
        return tagList;
    }

    @JvmStatic
    @NotNull
    public static final CWSPerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin) {
        return Companion.load(parameterBin, featureBin);
    }

    @JvmStatic
    @NotNull
    public static final CWSPerceptron load(@NotNull File dir) {
        return Companion.load(dir);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/mayabot/nlp/segment/cws/CWSPerceptron$Companion;", "", "()V", "B", "", "E", "M", "S", "tagList", "", "", "tagList$annotations", "getTagList", "()Ljava/util/List;", "load", "Lcom/mayabot/nlp/segment/cws/CWSPerceptron;", "dir", "Ljava/io/File;", "parameterBin", "Ljava/io/InputStream;", "featureBin", "mynlp-segment"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void tagList$annotations() {
        }

        @NotNull
        public final List<String> getTagList() {
            return tagList;
        }

        @JvmStatic
        @NotNull
        public final CWSPerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin) {
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            Intrinsics.checkParameterIsNotNull((Object)featureBin, (String)"featureBin");
            PerceptronModel model = PerceptronModel.Companion.load(parameterBin, featureBin, true);
            return new CWSPerceptron(model);
        }

        @JvmStatic
        @NotNull
        public final CWSPerceptron load(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Object object = new File(dir, "parameter.bin");
            Companion companion = this;
            InputStream inputStream = new FileInputStream((File)object);
            object = inputStream;
            int n = 8192;
            inputStream = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            object = new File(dir, "feature.dat");
            inputStream = inputStream;
            InputStream inputStream2 = new FileInputStream((File)object);
            object = inputStream2;
            n = 8192;
            inputStream2 = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            return companion.load(inputStream, inputStream2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

