/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.cws;

import com.mayabot.nlp.Mynlps;
import com.mayabot.nlp.segment.MynlpTokenizer;
import com.mayabot.nlp.segment.PipelineTokenizerBuilder;
import com.mayabot.nlp.segment.Sentence;
import com.mayabot.nlp.segment.core.ViterbiBestPathAlgorithm;
import com.mayabot.nlp.segment.cws.CWSSplitAlgorithm;
import com.mayabot.nlp.segment.cws.CwsService;
import com.mayabot.nlp.segment.plugins.AtomSplitAlgorithm;
import com.mayabot.nlp.segment.plugins.Correction;
import com.mayabot.nlp.segment.plugins.CustomDictionaryRecognition;
import com.mayabot.nlp.segment.plugins.PartOfSpeechTagging;
import com.mayabot.nlp.segment.plugins.correction.CorrectionWordpathProcessor;
import com.mayabot.nlp.segment.plugins.customwords.CustomDictionaryProcessor;
import com.mayabot.nlp.segment.plugins.pos.PosPerceptronProcessor;
import org.jetbrains.annotations.NotNull;

public class CWSTokenizerBuilder
extends PipelineTokenizerBuilder
implements CustomDictionaryRecognition,
PartOfSpeechTagging,
Correction {
    private boolean enablePOS = true;
    private boolean enableCorrection = true;
    private boolean enableCustomDictionary = false;

    public static CWSTokenizerBuilder builder() {
        return new CWSTokenizerBuilder();
    }

    public static void main(String[] args) {
        Mynlps.install(mynlpBuilder -> mynlpBuilder.set(CwsService.cwsModelItem, "cws-hanlp-model"));
        MynlpTokenizer tokenizer = CWSTokenizerBuilder.builder().build();
        Sentence sentence = tokenizer.parse("\u7ecf\u8fc7\u957f\u65f6\u95f4\u7684\u611f\u60c5\u63a2\u7d22\u548c\u4e34\u65f6\u5206\u5c45\u540e");
        System.out.println(sentence);
        System.out.println(tokenizer.parse("\u592e\u89c6\u7f51\u6d88\u606f\uff1a2019\u5e741\u670810\u65e5\uff0c\u5916\u4ea4\u90e8\u53d1\u8a00\u4eba\u9646\u6177\u4e3b\u6301\u4f8b\u884c\u8bb0\u8005\u4f1a\u3002\n\n\u3000\u3000\u8bb0\u8005\u95ee\uff1a\u4e2d\u56fd\u9a7b\u52a0\u62ff\u5927\u5927\u4f7f\u5362\u6c99\u91ce\u6628\u5929\uff089\u65e5\uff09\u53d1\u8868\u7684\u4e00\u7bc7\u6587\u7ae0\u5f15\u8d77\u4e86\u5916\u754c\u7684\u5173\u6ce8\u3002\u5362\u5927\u4f7f\u6587\u7ae0\u79f0\uff0c\u4e2d\u65b9\u62d8\u63552\u540d\u52a0\u62ff\u5927\u516c\u6c11\u662f\u5bf9\u52a0\u65b9\u62d8\u62bc\u5b5f\u665a\u821f\u7684\u62a5\u590d\uff0c\u79f0\u4e2d\u65b9\u4e3e\u63aa\u7cfb\u81ea\u536b\u884c\u4e3a\u3002\u8fd9\u662f\u5426\u76f8\u5f53\u4e8e\u627f\u8ba4\u4e86\u4e2d\u65b9\u62d8\u6355\u4e24\u540d\u52a0\u62ff\u5927\u4eba\u662f\u5bf9\u52a0\u65b9\u7684\u62a5\u590d\uff1f"));
    }

    @Override
    protected void setUp() {
        this.setBestPathComputer(ViterbiBestPathAlgorithm.class);
        this.addWordSplitAlgorithm(CWSSplitAlgorithm.class);
        this.addWordSplitAlgorithm(AtomSplitAlgorithm.class);
        if (this.enableCustomDictionary) {
            this.addProcessor(CustomDictionaryProcessor.class);
        }
        if (this.enableCorrection) {
            this.addProcessor(CorrectionWordpathProcessor.class);
        }
        if (this.enablePOS) {
            this.addProcessor(PosPerceptronProcessor.class);
        }
    }

    public boolean isEnableCustomDictionary() {
        return this.enableCustomDictionary;
    }

    @Override
    @NotNull
    public CWSTokenizerBuilder setEnableCustomDictionary(boolean enableCustomDictionary) {
        this.enableCustomDictionary = enableCustomDictionary;
        return this;
    }

    public boolean isEnablePOS() {
        return this.enablePOS;
    }

    @Override
    @NotNull
    public CWSTokenizerBuilder setEnablePOS(boolean enablePOS) {
        this.enablePOS = enablePOS;
        return this;
    }

    public boolean isEnableCorrection() {
        return this.enableCorrection;
    }

    @Override
    @NotNull
    public CWSTokenizerBuilder setEnableCorrection(boolean enableCorrection) {
        this.enableCorrection = enableCorrection;
        return this;
    }
}

