/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.cws;

import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.segment.cws.CwsPatch;
import com.mayabot.nlp.utils.CharSourceLineReader;
import com.mayabot.t.google.inject.Inject;
import com.mayabot.t.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/mayabot/nlp/segment/cws/CwsPatch;", "", "mynlpEnv", "Lcom/mayabot/nlp/MynlpEnv;", "(Lcom/mayabot/nlp/MynlpEnv;)V", "examples", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getExamples", "()Ljava/util/ArrayList;", "getMynlpEnv", "()Lcom/mayabot/nlp/MynlpEnv;", "addExample", "", "line", "addResources", "rsName", "loadExample", "", "removeExample", "mynlp-segment"})
public final class CwsPatch {
    @NotNull
    private final ArrayList<String> examples;
    @NotNull
    private final MynlpEnv mynlpEnv;

    @NotNull
    public final ArrayList<String> getExamples() {
        return this.examples;
    }

    public final void addExample(@NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Collection collection = this.examples;
        collection.add(line);
    }

    public final void removeExample(@NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        this.examples.remove(line);
    }

    public final void addResources(@NotNull String rsName) {
        Intrinsics.checkParameterIsNotNull((Object)rsName, (String)"rsName");
        Collection collection = this.examples;
        Iterable iterable = this.loadExample(rsName);
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
    }

    private final List<String> loadExample(String rsName) {
        NlpResource resource = this.mynlpEnv.loadResource(rsName);
        if (resource != null) {
            CharSourceLineReader charSourceLineReader = resource.openLineReader();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSourceLineReader, (String)"resource.openLineReader()");
            return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)charSourceLineReader), (Function1)loadExample.1.INSTANCE), (Function1)loadExample.2.INSTANCE));
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final MynlpEnv getMynlpEnv() {
        return this.mynlpEnv;
    }

    @Inject
    public CwsPatch(@NotNull MynlpEnv mynlpEnv) {
        Intrinsics.checkParameterIsNotNull((Object)mynlpEnv, (String)"mynlpEnv");
        this.mynlpEnv = mynlpEnv;
        this.examples = new ArrayList();
        Collection collection = this.examples;
        Iterable iterable = this.loadExample("patch/cws-default.txt");
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = this.examples;
        iterable = this.loadExample("patch/cws.txt");
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
    }
}

