/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins;

import com.mayabot.nlp.collection.dat.DoubleArrayTrieStringIntMap;
import com.mayabot.nlp.collection.dat.FastDatCharSet;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordSplitAlgorithm;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.common.String2;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.t.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/mayabot/nlp/segment/plugins/AtomSplitAlgorithm;", "Lcom/mayabot/nlp/segment/common/BaseSegmentComponent;", "Lcom/mayabot/nlp/segment/WordSplitAlgorithm;", "()V", "chineseNumSet", "Lcom/mayabot/nlp/collection/dat/FastDatCharSet;", "getChineseNumSet", "()Lcom/mayabot/nlp/collection/dat/FastDatCharSet;", "dat", "Lcom/mayabot/nlp/collection/dat/DoubleArrayTrieStringIntMap;", "getDat", "()Lcom/mayabot/nlp/collection/dat/DoubleArrayTrieStringIntMap;", "emailPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getEmailPattern", "()Ljava/util/regex/Pattern;", "xPattern", "getXPattern", "fill", "", "wordnet", "Lcom/mayabot/nlp/segment/wordnet/Wordnet;", "parseTemplate", "", "", "template", "mynlp-segment"})
public final class AtomSplitAlgorithm
extends BaseSegmentComponent
implements WordSplitAlgorithm {
    @NotNull
    private final FastDatCharSet chineseNumSet = new FastDatCharSet('\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d', '\u4e24', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396', '\u62fe', '\u5341', '\u767e', '\u5343', '\u4e07', '\u4ebf');
    @NotNull
    private final DoubleArrayTrieStringIntMap dat;
    private final Pattern emailPattern = Pattern.compile("[NA]+@[NA]+NA+");
    private final Pattern xPattern = Pattern.compile("A+[N\\-][N\\-A]*");

    @NotNull
    public final FastDatCharSet getChineseNumSet() {
        return this.chineseNumSet;
    }

    @NotNull
    public final DoubleArrayTrieStringIntMap getDat() {
        return this.dat;
    }

    public final Pattern getEmailPattern() {
        return this.emailPattern;
    }

    public final Pattern getXPattern() {
        return this.xPattern;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(@NotNull Wordnet wordnet) {
        char c;
        Intrinsics.checkParameterIsNotNull((Object)wordnet, (String)"wordnet");
        char[] cArray = wordnet.getCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"wordnet.charArray");
        char[] chars = cArray;
        boolean foundNum = false;
        boolean foundAlpha = false;
        boolean foundAt = false;
        int n = 0;
        int n2 = chars.length;
        while (n < n2) {
            void i;
            c = chars[i];
            if (c < '{') {
                if (c >= '0' && c <= '9') {
                    foundNum = true;
                } else if (c >= 'a' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    foundAlpha = true;
                }
            } else if (this.chineseNumSet.contains(c)) {
                foundNum = true;
            }
            if (foundAlpha || foundNum) break;
            ++i;
        }
        boolean foundBigX = false;
        if (foundNum || foundAlpha) {
            char[] newChars = Arrays.copyOf(chars, chars.length);
            c = '\u0000';
            int n3 = chars.length;
            while (c < n3) {
                void i;
                char c2 = chars[i];
                if (c2 < '{') {
                    if (c2 >= '0' && c2 <= '9') {
                        newChars[i] = 78;
                    } else if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '_') {
                        newChars[i] = 65;
                    } else if (c2 == '.') {
                        newChars[i] = 78;
                    } else if (c2 == '@') {
                        foundAt = true;
                    }
                } else if (this.chineseNumSet.contains(c2)) {
                    newChars[i] = 90;
                }
                ++i;
            }
            DoubleArrayTrieStringIntMap.DATMapLongMatcherInt match = this.dat.matchLong(newChars, 0);
            int bigXEnd = -1;
            while (match.next()) {
                DoubleArrayTrieStringIntMap.DATMapLongMatcherInt dATMapLongMatcherInt = match;
                Intrinsics.checkExpressionValueIsNotNull((Object)dATMapLongMatcherInt, (String)"match");
                int type = dATMapLongMatcherInt.getValue();
                int offset = match.getBegin();
                int length = match.getLength();
                switch (type) {
                    case 1: {
                        wordnet.put(offset, length).setAbsWordNatureAndFreq(Nature.t);
                        break;
                    }
                    case 2: {
                        if (length == 1 && chars[offset] == '.') break;
                        if (offset == bigXEnd) {
                            foundBigX = true;
                        }
                        wordnet.put(offset, length).setAbsWordNatureAndFreq(Nature.m);
                        break;
                    }
                    case 3: {
                        wordnet.put(offset, length).setAbsWordNatureAndFreq(Nature.mq);
                        break;
                    }
                    case 4: {
                        wordnet.put(offset, length).setAbsWordNatureAndFreq(Nature.x);
                        bigXEnd = offset + length;
                        break;
                    }
                    case 5: {
                        if (offset != bigXEnd) break;
                        foundBigX = true;
                    }
                }
            }
            if (foundAt) {
                Matcher matcher = this.emailPattern.matcher(new String2(newChars));
                while (matcher.find()) {
                    wordnet.put(matcher.start(), matcher.end() - matcher.start()).setAbsWordNatureAndFreq(Nature.x);
                }
            }
            if (foundBigX) {
                Matcher matcher = this.xPattern.matcher(new String2(newChars));
                while (matcher.find()) {
                    wordnet.put(matcher.start(), matcher.end() - matcher.start()).setAbsWordNatureAndFreq(Nature.x);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> parseTemplate(String template) {
        void $receiver$iv$iv;
        Object part;
        Regex pattern = new Regex("(\\{(.+?)\\})|(.+?)");
        ArrayList<List> list = new ArrayList<List>();
        Object $receiver$iv = Regex.findAll$default((Regex)pattern, (CharSequence)template, (int)0, (int)2, null);
        for (Object element$iv : $receiver$iv) {
            Integer n;
            Collection<Object> collection;
            int n2;
            int n3;
            Object object;
            MatchResult mr = (MatchResult)element$iv;
            boolean bl = false;
            part = mr.getValue();
            if (StringsKt.startsWith$default((String)part, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)part, (String)"}", (boolean)false, (int)2, null)) {
                object = part;
                n3 = 1;
                n2 = ((String)part).length() - 1;
                String string = object;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = string.substring(n3, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                part = string2;
            }
            if (StringsKt.startsWith$default((String)part, (String)"(", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)part, (String)")", (boolean)false, (int)2, null)) {
                object = part;
                n3 = 1;
                n2 = ((String)part).length() - 1;
                collection = list;
                Object object2 = object;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((String)object2).substring(n3, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                ((ArrayList)collection).add(CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)((CharSequence)((Object)n)), (String[])new String[]{"|"}, (boolean)false, (int)0, (int)6, null)));
                continue;
            }
            if (StringsKt.contains$default((CharSequence)((CharSequence)part), (CharSequence)"[", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)part), (CharSequence)"|", (boolean)false, (int)2, null)) {
                ArrayList<String> arrayList;
                Object object3;
                Iterable $receiver$iv2;
                String range;
                ArrayList<String> st = new ArrayList<String>();
                Object object4 = part;
                int n4 = 0;
                int n5 = StringsKt.indexOf$default((CharSequence)((CharSequence)part), (String)"[", (int)0, (boolean)false, (int)6, null);
                Object object5 = object4;
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)object5).substring(n4, n5);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                List e = StringsKt.split$default((CharSequence)string, (String[])new String[]{"|"}, (boolean)false, (int)0, (int)6, null);
                Object object6 = part;
                n5 = StringsKt.indexOf$default((CharSequence)((CharSequence)part), (String)"[", (int)0, (boolean)false, (int)6, null) + 1;
                int n6 = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)part), (String)"]", (int)0, (boolean)false, (int)6, null);
                Object object7 = object6;
                if (object7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((String)object7).substring(n5, n6), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (StringsKt.contains$default((CharSequence)range, (CharSequence)",", (boolean)false, (int)2, null)) {
                    Iterator $receiver$iv$iv2;
                    Iterable iterable = $receiver$iv2 = (Iterable)StringsKt.split$default((CharSequence)range, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    Iterator iterator = $receiver$iv$iv2.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Object item$iv$iv = iterator.next();
                        object3 = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        arrayList = it;
                        n = Integer.parseInt(arrayList);
                        collection.add(n);
                    }
                    $receiver$iv2 = (List)destination$iv$iv;
                    $receiver$iv$iv2 = $receiver$iv2.iterator();
                    while ($receiver$iv$iv2.hasNext()) {
                        Object element$iv2 = $receiver$iv$iv2.next();
                        int n7 = ((Number)element$iv2).intValue();
                        boolean bl3 = false;
                        Iterable $receiver$iv3 = e;
                        for (Object element$iv3 : $receiver$iv3) {
                            String it = (String)element$iv3;
                            boolean bl4 = false;
                            st.add(StringsKt.repeat((CharSequence)it, (int)n7));
                        }
                    }
                } else if (StringsKt.contains$default((CharSequence)range, (CharSequence)"-", (boolean)false, (int)2, null)) {
                    int end;
                    int n7;
                    String $receiver$iv$iv2 = (String)StringsKt.split$default((CharSequence)range, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null).get(0);
                    int start = Integer.parseInt($receiver$iv$iv2);
                    int element$iv2 = start;
                    if (element$iv2 <= (n7 = (end = Integer.parseInt(element$iv2 = (String)StringsKt.split$default((CharSequence)range, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null).get(1))))) {
                        while (true) {
                            void n8;
                            Iterable $receiver$iv4 = e;
                            for (Object element$iv4 : $receiver$iv4) {
                                String it = (String)element$iv4;
                                boolean bl5 = false;
                                st.add(StringsKt.repeat((CharSequence)it, (int)n8));
                            }
                            if (n8 != n7) {
                                ++n8;
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    $receiver$iv2 = e;
                    for (Object element$iv5 : $receiver$iv2) {
                        String it = (String)element$iv5;
                        boolean bl6 = false;
                        object3 = range;
                        CharSequence charSequence = it;
                        arrayList = st;
                        int n9 = Integer.parseInt((String)object3);
                        arrayList.add(StringsKt.repeat((CharSequence)charSequence, (int)n9));
                    }
                }
                list.add(st);
                continue;
            }
            list.add(CollectionsKt.listOf((Object)part));
        }
        List list2 = Lists.cartesianProduct((List)list);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Lists.cartesianProduct(list)");
        $receiver$iv = list2;
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            part = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v7 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it");
            String string = CollectionsKt.joinToString$default((Iterable)((Iterable)v7), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public AtomSplitAlgorithm() {
        this.setOrder(0);
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        Function3<TreeMap<String, Integer>, String, Integer, Unit> addTemplate$ = new Function3<TreeMap<String, Integer>, String, Integer, Unit>(){

            public final void invoke(@NotNull TreeMap<String, Integer> $receiver, @NotNull String template, int type) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
                Iterable $receiver$iv = this.parseTemplate(template);
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Map map = $receiver;
                    Integer n = type;
                    map.put(it, n);
                }
            }
        };
        Map map = treeMap;
        String string = "\u5468Z";
        Integer n = 1;
        map.put(string, n);
        map = treeMap;
        string = "\u661f\u671fZ";
        n = 1;
        map.put(string, n);
        addTemplate$.invoke(treeMap, "{N[2,4]}\u5e74{N[1,2]}\u6708{N[1,2]}{(\u65e5|\u53f7)}", 1);
        addTemplate$.invoke(treeMap, "{N[2,4]}-{N[2]}-{N[2]}", 1);
        addTemplate$.invoke(treeMap, "{N|Z[2,4]}{(\u5e74|\u5e74\u5ea6)}", 1);
        addTemplate$.invoke(treeMap, "{N|Z[2,4]}\u5e74{N[1,2]}\u6708", 1);
        addTemplate$.invoke(treeMap, "{N|Z[1,2]}{(\u6708|\u6708\u4efd)}", 1);
        addTemplate$.invoke(treeMap, "{N|Z[1,2]}\u6708{N|Z[1-3]}{(\u65e5|\u53f7)}", 1);
        addTemplate$.invoke(treeMap, "{N[1,2]}{(\u65e5|\u53f7)}", 1);
        addTemplate$.invoke(treeMap, "{Z[1-3]}{(\u65e5|\u53f7)}", 1);
        addTemplate$.invoke(treeMap, "{N|Z[1-5]}\u5929", 1);
        addTemplate$.invoke(treeMap, "{N|Z[1-5]}\u4e2a\u6708", 1);
        addTemplate$.invoke(treeMap, "{N|Z[1-5]}\u5468", 1);
        addTemplate$.invoke(treeMap, "{Z|N[1-2]}{(\u70b9|\u70b9\u949f|\u70b9\u534a|\u70b9N\u523b)}", 1);
        addTemplate$.invoke(treeMap, "{N[1-2]}\u70b9{N[1-2]}\u5206", 1);
        addTemplate$.invoke(treeMap, "{Z[1-3]}\u70b9{N[1-3]}\u5206", 1);
        addTemplate$.invoke(treeMap, "{Z|N[1-3]}{(\u5c0f\u65f6|\u4e2a\u5c0f\u65f6)}", 1);
        addTemplate$.invoke(treeMap, "{Z|N[1-3]}{(\u5206|\u5206\u949f)}", 1);
        addTemplate$.invoke(treeMap, "{Z|N[1-3]}{(\u79d2|\u79d2\u949f)}", 1);
        addTemplate$.invoke(treeMap, "{N[1-50]}", 2);
        addTemplate$.invoke(treeMap, "-{N[1-50]}", 2);
        addTemplate$.invoke(treeMap, "{Z[1-30]}", 2);
        addTemplate$.invoke(treeMap, "\u8d1f{Z[1-30]}", 2);
        addTemplate$.invoke(treeMap, "{Z[1-20]}\u70b9{N[1,20]}", 2);
        addTemplate$.invoke(treeMap, "\u8d1f{Z[1-20]}\u70b9{N[1,20]}", 2);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(\u5143|\u4e32|\u4e8b|\u518c|\u4e18|\u4e0b|\u4e08|\u4e1d|\u4e3e|\u5177|\u5305|\u5398|\u5200|\u5206|\u5217|\u5219|\u5242|\u526f|\u4e9b|\u531d|\u961f|\u90e8|\u51fa|\u4e2a)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(\u4ecb|\u4ee4|\u4efd|\u4f19|\u4ef6|\u4efb|\u500d|\u510b|\u4ea9|\u8bb0|\u53cc|\u53d1|\u53e0|\u8282|\u830e|\u901a|\u9020|\u904d|\u9053)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(\u906d|\u5bf9|\u5c0a|\u5934|\u5957|\u5f13|\u5f15|\u5f20|\u5f2f|\u5f00|\u5e84|\u5e8a|\u5ea7|\u5eb9|\u5e16|\u5e27|\u5e2d|\u5e38|\u5e45|\u5e62|\u53e3|\u53e5|\u53f7|\u53f0|\u53ea|\u540a|\u5408|\u540d)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(\u5428|\u548c|\u5473|\u54cd|\u9a91|\u95e8|\u95f4|\u9615|\u5b97|\u5ba2|\u5bb6|\u5f6a|\u5c42|\u5c3e|\u5c4a|\u58f0|\u624e|\u6253|\u6263|\u628a|\u629b|\u6279|\u6294|\u62b1|\u62e8|\u62c5|\u62c9|\u62ac)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(\u62c3|\u6302|\u6311|\u633a|\u6346|\u63ac|\u6392|\u6367|\u6390|\u63d0|\u63e1|\u644a|\u645e|\u6487|\u64ae|\u6c6a|\u6cd3|\u6ce1|\u6ce8|\u6d54|\u6d3e|\u6e7e|\u6e9c|\u6ee9|\u6ef4|\u7ea7|\u7eb8|\u7ebf)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(\u7ec4|\u7ede|\u7edf|\u7efa|\u7efc|\u7f15|\u7f17|\u573a|\u5757|\u575b|\u579b|\u5835|\u5806|\u5802|\u5854|\u58a9|\u56de|\u56e2|\u56f4|\u5708|\u5b54|\u8d34|\u70b9|\u714e|\u719f|\u8f66|\u8f6e|\u8f6c)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(\u8f7d|\u8f86|\u6599|\u5377|\u622a|\u6237|\u623f|\u6240|\u6247|\u7089|\u70b7|\u89c9|\u65a4|\u7b14|\u672c|\u6735|\u6746|\u675f|\u6761|\u676f|\u679a|\u679d|\u67c4|\u680b|\u67b6|\u6839|\u6844|\u6883)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(\u6837|\u682a|\u6869|\u68ad|\u6876|\u68f5|\u6980|\u69fd|\u728b|\u723f|\u7247|\u7248|\u6b47|\u624b|\u62f3|\u6bb5|\u6c93|\u73ed|\u6587|\u66f2|\u66ff|\u80a1|\u80a9|\u812c|\u8154|\u652f|\u6b65|\u6b66)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(\u74e3|\u79d2|\u79e9|\u949f|\u94b1|\u94e2|\u950a|\u94fa|\u9524|\u952d|\u9531|\u7ae0|\u76c6|\u76cf|\u76d8|\u7709|\u773c|\u77f3|\u7801|\u7823|\u7897|\u78f4|\u7968|\u7f57|\u7548|\u756a|\u7a9d|\u8054)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(\u7f36|\u8026|\u7c92|\u7d22|\u7d2f|\u7dc9|\u822c|\u8258|\u7aff|\u7b65|\u7b52|\u7b79|\u7ba1|\u7bc7|\u7bb1|\u7c07|\u89d2|\u91cd|\u8eab|\u8eaf|\u9172|\u8d77|\u8d9f|\u9762|\u9996|\u9879|\u9886|\u9876|\u9897|\u9877|\u88ad|\u7fa4|\u888b)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(\u516c\u91cc|\u7c73|\u5343\u7c73|\u5398\u7c73|\u6beb\u7c73|\u5fae\u7c73|\u7eb3\u7c73|\u98de\u7c73|km|dm|cm|mm|\u03bcm|nm|fm)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(kg|dg|cg|mg|\u516c\u65a4|\u65a4|\u514b|\u6beb\u514b)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(dl|cl|ml|\u6beb\u5347|\u5347)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(mhz|khz|\u8d6b\u5179)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(mpa|kpa|hpa|\u5e15)}", 3);
        addTemplate$.invoke(treeMap, "{Z|N[1-10]}{(tb|gb|mb|kb|\u5b57\u8282|\u5146)}", 3);
        addTemplate$.invoke(treeMap, "{N[1-10]}{A[1-3]}", 3);
        addTemplate$.invoke(treeMap, "{A[2-100]}", 4);
        addTemplate$.invoke(treeMap, "-", 5);
        this.dat = new DoubleArrayTrieStringIntMap(treeMap);
    }
}

