/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins;

import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordpathProcessor;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.nlp.segment.wordnet.Wordpath;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternWordpathProcessor
extends BaseSegmentComponent
implements WordpathProcessor {
    private Pattern pattern;

    public PatternWordpathProcessor(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public Wordpath process(Wordpath wordPath) {
        Wordnet wordnet = wordPath.getWordnet();
        Matcher matcher = this.pattern.matcher(wordnet);
        while (matcher.find()) {
            int len;
            int start = matcher.start();
            if (wordPath.willCutOtherWords(start, len = matcher.end() - start)) continue;
            Vertex vertex = wordPath.combine(start, len);
            vertex.setAbsWordNatureAndFreq(Nature.x);
        }
        return wordPath;
    }
}

