/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.collector;

import com.mayabot.nlp.collection.dat.DATMapMatcher;
import com.mayabot.nlp.collection.dat.DoubleArrayTrieMap;
import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.WordTermCollector;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.VertexRow;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.nlp.segment.wordnet.Wordpath;
import com.mayabot.nlp.utils.StringUtils;
import com.mayabot.t.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SentenceIndexWordCollector
implements WordTermCollector {
    private int minWordLength = 2;
    private int longWordLength = 3;
    private boolean folded = false;
    private DoubleArrayTrieMap<String[]> excludeDict;
    private Predicate<Vertex> excludeFilter;
    private DoubleArrayTrieMap[] dictList;

    @Override
    public void collect(Wordnet wordnet, Wordpath wordPath, Consumer<WordTerm> consumer) {
        char[] text = wordnet.getCharArray();
        if (this.dictList != null) {
            for (DoubleArrayTrieMap dict : this.dictList) {
                DATMapMatcher searcher = dict.match(text, 0);
                while (searcher.next()) {
                    int offset = searcher.getBegin();
                    int length = searcher.getLength();
                    VertexRow row = wordnet.getRow(offset);
                    if (row.contains(length)) continue;
                    Vertex v = new Vertex(length);
                    wordnet.put(offset, v);
                }
            }
        }
        Iterator<Vertex> vertexIterator = wordPath.iteratorVertex();
        while (vertexIterator.hasNext()) {
            Vertex vertex = vertexIterator.next();
            WordTerm term = new WordTerm(vertex.realWord(), vertex.nature, vertex.getRowNum());
            if (StringUtils.isWhiteSpace(term.word)) continue;
            consumer.accept(term);
            if (vertex.length < this.longWordLength || this.excludeFilter != null && this.excludeFilter.test(vertex)) continue;
            ArrayList<WordTerm> subwords = null;
            if (this.folded) {
                subwords = Lists.newArrayList();
                term.setSubword(subwords);
            }
            int lastIndex = vertex.length + vertex.getRowNum();
            int from = vertex.getRowNum();
            int to = from + vertex.length;
            String[] exclude = null;
            if (this.excludeDict != null) {
                exclude = this.excludeDict.get(text, from, vertex.length);
            }
            for (int i = from; i < to; ++i) {
                VertexRow row = wordnet.getRow(i);
                block4: for (Vertex small = row.first(); small != null; small = small.next()) {
                    if (small.length < this.minWordLength || i + small.length() > lastIndex || small == vertex) continue;
                    String word = small.realWord();
                    if (exclude != null) {
                        if (exclude.length == 1) {
                            if (exclude[0].equals(word)) {
                                continue;
                            }
                        } else {
                            for (String s : exclude) {
                                if (s.equals(word)) continue block4;
                            }
                        }
                    }
                    WordTerm smallterm = new WordTerm(small.realWord(), small.nature, small.getRowNum());
                    if (this.folded) {
                        subwords.add(smallterm);
                        continue;
                    }
                    consumer.accept(smallterm);
                }
            }
        }
    }

    public int getMinWordLength() {
        return this.minWordLength;
    }

    public SentenceIndexWordCollector setMinWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
        return this;
    }

    public SentenceIndexWordCollector setFolded(boolean folded) {
        this.folded = folded;
        return this;
    }

    public boolean isFolded() {
        return this.folded;
    }

    public SentenceIndexWordCollector setExcludeDict(DoubleArrayTrieMap<String[]> excludeDict) {
        this.excludeDict = excludeDict;
        return this;
    }

    public SentenceIndexWordCollector setExcludeDict(TreeMap<String, String[]> excludeDict) {
        this.excludeDict = new DoubleArrayTrieMap<String[]>(excludeDict);
        return this;
    }

    public Predicate<Vertex> getExcludeFilter() {
        return this.excludeFilter;
    }

    public SentenceIndexWordCollector setExcludeFilter(Predicate<Vertex> excludeFilter) {
        this.excludeFilter = excludeFilter;
        return this;
    }

    public int getLongWordLength() {
        return this.longWordLength;
    }

    public SentenceIndexWordCollector setLongWordLength(int longWordLength) {
        this.longWordLength = longWordLength;
        return this;
    }

    public DoubleArrayTrieMap[] getDictList() {
        return this.dictList;
    }

    public SentenceIndexWordCollector setDictList(DoubleArrayTrieMap[] dictList) {
        this.dictList = dictList;
        return this;
    }

    public SentenceIndexWordCollector setDictList(List<DoubleArrayTrieMap> dictList) {
        this.dictList = dictList.toArray(new DoubleArrayTrieMap[0]);
        return this;
    }
}

