/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.correction;

import com.mayabot.t.google.common.base.Joiner;
import com.mayabot.t.google.common.base.Splitter;
import com.mayabot.t.google.common.collect.Lists;
import com.mayabot.t.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;

public class CorrectionWord {
    public String path;
    public String raw;
    public int[] words;
    static Splitter splitter = Splitter.on("/").trimResults().omitEmptyStrings();

    public int[] getWords() {
        return this.words;
    }

    public String getPath() {
        return this.path;
    }

    public String getRaw() {
        return this.raw;
    }

    public static CorrectionWord parse(String line) {
        CorrectionWord adjustWord = new CorrectionWord();
        adjustWord.raw = line.trim();
        List<String> list = splitter.splitToList(adjustWord.raw);
        adjustWord.path = Joiner.on("").join(list);
        ArrayList<Integer> words = Lists.newArrayList();
        for (String s : list) {
            words.add(s.length());
        }
        adjustWord.words = Ints.toArray(words);
        return adjustWord;
    }

    public String toString() {
        return "CorrectionWord{path='" + this.path + '\'' + ", raw='" + this.raw + '\'' + ", words=" + this.words + '}';
    }
}

