/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.correction;

import com.mayabot.nlp.collection.dat.DATMapMatcher;
import com.mayabot.nlp.collection.dat.DoubleArrayTrieMap;
import com.mayabot.nlp.segment.WordpathProcessor;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.plugins.correction.CorrectionDictionary;
import com.mayabot.nlp.segment.plugins.correction.CorrectionWord;
import com.mayabot.nlp.segment.wordnet.Wordpath;
import com.mayabot.t.google.inject.Inject;
import com.mayabot.t.google.inject.Singleton;

@Singleton
public class CorrectionWordpathProcessor
extends BaseSegmentComponent
implements WordpathProcessor {
    private final CorrectionDictionary dictionary;

    @Inject
    public CorrectionWordpathProcessor(CorrectionDictionary dictionary) {
        this.dictionary = dictionary;
        this.setOrder(10000);
    }

    @Override
    public Wordpath process(Wordpath wordPath) {
        DoubleArrayTrieMap<CorrectionWord> dat = this.dictionary.getTrie();
        if (dat == null) {
            return wordPath;
        }
        DATMapMatcher<CorrectionWord> datSearch = dat.match(wordPath.getWordnet().getCharArray(), 0);
        while (datSearch.next()) {
            int offset = datSearch.getBegin();
            if (wordPath.willCutOtherWords(offset, datSearch.getLength())) continue;
            CorrectionWord aw = datSearch.getValue();
            for (int len : aw.getWords()) {
                wordPath.combine(offset, len);
                offset += len;
            }
        }
        return wordPath;
    }
}

