/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.correction;

import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.SettingItem;
import com.mayabot.nlp.collection.dat.DoubleArrayTrieMap;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.segment.plugins.correction.CorrectionDictionary;
import com.mayabot.nlp.segment.plugins.correction.CorrectionWord;
import com.mayabot.nlp.utils.CharSourceLineReader;
import com.mayabot.t.google.inject.Inject;
import com.mayabot.t.google.inject.Singleton;
import java.util.List;
import java.util.TreeMap;

@Singleton
public class DefaultCorrectionDictionary
implements CorrectionDictionary {
    static InternalLogger logger = InternalLoggerFactory.getInstance(DefaultCorrectionDictionary.class);
    public static final SettingItem<String> correctionDict = SettingItem.string("correction.dict", "dictionary/correction.txt");
    private DoubleArrayTrieMap<CorrectionWord> doubleArrayTrie;

    @Override
    public DoubleArrayTrieMap<CorrectionWord> getTrie() {
        return this.doubleArrayTrie;
    }

    @Inject
    public DefaultCorrectionDictionary(MynlpEnv mynlp) throws Exception {
        List<String> resourceUrls = mynlp.getSettings().getAsList(correctionDict);
        if (resourceUrls.isEmpty()) {
            return;
        }
        this.loadFromRealData(mynlp, resourceUrls);
    }

    public void loadFromRealData(MynlpEnv mynlp, List<String> resourceUrls) throws Exception {
        TreeMap<String, CorrectionWord> map = new TreeMap<String, CorrectionWord>();
        for (String url : resourceUrls) {
            NlpResource resource = mynlp.loadResource(url);
            if (resource != null) {
                try (CharSourceLineReader reader = resource.openLineReader();){
                    while (reader.hasNext()) {
                        String line = (String)reader.next();
                        CorrectionWord adjustWord = CorrectionWord.parse(line);
                        map.put(adjustWord.path, adjustWord);
                    }
                }
            }
            if (map.isEmpty()) {
                return;
            }
            this.doubleArrayTrie = new DoubleArrayTrieMap(map);
        }
    }
}

