/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.correction;

import com.mayabot.nlp.collection.dat.DoubleArrayTrieMap;
import com.mayabot.nlp.segment.plugins.correction.CorrectionDictionary;
import com.mayabot.nlp.segment.plugins.correction.CorrectionWord;
import com.mayabot.t.google.common.collect.ImmutableList;
import com.mayabot.t.google.common.collect.Maps;
import com.mayabot.t.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.TreeMap;

public class FileCorrectionDictionary
implements CorrectionDictionary {
    private TreeMap<String, CorrectionWord> dict;
    private DoubleArrayTrieMap<CorrectionWord> trie;

    public FileCorrectionDictionary(File file, Charset charset) throws IOException {
        TreeMap<String, CorrectionWord> dict = Maps.newTreeMap();
        ImmutableList<String> lines = Files.asCharSource(file, charset).readLines();
        for (String line : lines) {
            CorrectionWord adjustWord = CorrectionWord.parse(line);
            dict.put(adjustWord.path, adjustWord);
        }
        this.trie = new DoubleArrayTrieMap(dict);
    }

    @Override
    public DoubleArrayTrieMap<CorrectionWord> getTrie() {
        return this.trie;
    }
}

