/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.correction;

import com.mayabot.nlp.collection.dat.DoubleArrayTrieMap;
import com.mayabot.nlp.segment.plugins.correction.CorrectionDictionary;
import com.mayabot.nlp.segment.plugins.correction.CorrectionWord;
import java.util.TreeMap;

public class MemCorrectionDictionary
implements CorrectionDictionary {
    private TreeMap<String, CorrectionWord> dict;
    private DoubleArrayTrieMap<CorrectionWord> trie;

    public MemCorrectionDictionary(TreeMap<String, CorrectionWord> dict) {
        this.dict = dict;
        this.rebuild();
    }

    public MemCorrectionDictionary() {
        this.dict = new TreeMap();
        this.rebuild();
    }

    public void rebuild() {
        if (this.dict.isEmpty()) {
            this.trie = null;
            return;
        }
        this.trie = new DoubleArrayTrieMap<CorrectionWord>(this.dict);
    }

    public void addWord(String rule) {
        CorrectionWord adjustWord = CorrectionWord.parse(rule);
        this.dict.put(adjustWord.path, adjustWord);
    }

    public void removeWord(String word) {
        this.dict.remove(word);
    }

    @Override
    public DoubleArrayTrieMap<CorrectionWord> getTrie() {
        return this.trie;
    }
}

