/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.ner;

import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordpathProcessor;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.plugins.ner.PerceptronNerService;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordpath;
import com.mayabot.t.google.common.collect.Lists;
import com.mayabot.t.google.inject.Inject;
import com.mayabot.t.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class NerProcessor
extends BaseSegmentComponent
implements WordpathProcessor {
    private final PerceptronNerService service;

    @Inject
    NerProcessor(PerceptronNerService perceptronPosService) {
        this.setOrder(10000);
        this.service = perceptronPosService;
    }

    @Override
    public Wordpath process(Wordpath wordPath) {
        ArrayList<Vertex> vertices = Lists.newArrayList(wordPath.iteratorVertex());
        List<String> tagS = this.service.getPerceptron().decodeVertexList(vertices);
        int from = -1;
        int lenght = 0;
        for (int i = 0; i < vertices.size(); ++i) {
            String tag = tagS.get(i);
            Vertex vertex = vertices.get(i);
            if ("O".equals(tag) || "S".equals(tag)) {
                from = -1;
                lenght = 0;
                continue;
            }
            if (tag.startsWith("B-")) {
                from = vertex.offset();
                lenght += vertex.length;
                continue;
            }
            if (tag.startsWith("M-")) {
                lenght += vertex.length;
                continue;
            }
            if (!tag.startsWith("E-")) continue;
            lenght += vertex.length;
            if (from == -1) continue;
            Vertex x = wordPath.combine(from, lenght);
            if (tag.equals("E-nt")) {
                x.nature = Nature.nt;
            }
            if (!tag.equals("E-ns")) continue;
            x.nature = Nature.ns;
        }
        return wordPath;
    }
}

