/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.personname;

import com.mayabot.nlp.segment.plugins.personname.NREvaluate;
import com.mayabot.nlp.segment.plugins.personname.NRPerceptronSample;
import com.mayabot.nlp.segment.plugins.personname.PersonName;
import com.mayabot.nlp.segment.plugins.personname.PersonNamePerceptron;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Lcom/mayabot/nlp/segment/plugins/personname/NREvaluate;", "", "()V", "evaluate", "", "evaluateSample", "", "Lcom/mayabot/nlp/segment/plugins/personname/NREvaluate$EvaluateSample;", "segmenter", "Lcom/mayabot/nlp/segment/plugins/personname/PersonNamePerceptron;", "text2EvaluateSample", "text", "", "EvaluateSample", "mynlp-segment"})
public final class NREvaluate {
    public static final NREvaluate INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EvaluateSample text2EvaluateSample(@NotNull String text) {
        List list;
        void $receiver$iv$iv;
        void $receiver$iv;
        Object s2;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String juzi = NRPerceptronSample.INSTANCE.sample2Juzi(text);
        int offset = 0;
        ArrayList list2 = new ArrayList();
        int p = -1;
        StringBuilder buffer = new StringBuilder();
        for (Object s2 : StringsKt.split$default((CharSequence)text, (String[])new String[]{"\ufe4d"}, (boolean)false, (int)0, (int)6, null)) {
            String word = String.valueOf(((String)s2).charAt(0));
            String label = String.valueOf(((String)s2).charAt(1));
            if (Intrinsics.areEqual((Object)label, (Object)"B")) {
                p = offset;
            }
            switch (label) {
                case "B": {
                    p = offset;
                    buffer.append(word);
                    break;
                }
                case "M": {
                    Object object = buffer;
                    if (!(object.length() > 0)) break;
                    buffer.append(word);
                    break;
                }
                case "E": {
                    buffer.append(word);
                    Object object = list2;
                    String string = buffer.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
                    PersonName personName = new PersonName(string, p);
                    object.add(personName);
                    p = -1;
                    StringsKt.clear((StringBuilder)buffer);
                    break;
                }
                default: {
                    p = -1;
                    StringsKt.clear((StringBuilder)buffer);
                }
            }
            ++offset;
        }
        s2 = list2;
        String string = juzi;
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PersonName it = (PersonName)element$iv$iv;
            boolean bl = false;
            if (!(it.getName().length() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = list = (List)destination$iv$iv;
        String string2 = string;
        return new EvaluateSample(string2, list3);
    }

    @NotNull
    public final double[] evaluate(@NotNull List<EvaluateSample> evaluateSample2, @NotNull PersonNamePerceptron segmenter) {
        Object object;
        Object object2;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull(evaluateSample2, (String)"evaluateSample");
        Intrinsics.checkParameterIsNotNull((Object)segmenter, (String)"segmenter");
        int goldTotal = 0;
        int predTotal = 0;
        int correct = 0;
        long t1 = System.currentTimeMillis();
        for (EvaluateSample ex : evaluateSample2) {
            Object[] text = ex.getJuzi();
            List<PersonName> goldNames = ex.getGoldNames();
            objectArray = text;
            object2 = segmenter;
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray.toCharArray(), (String)"(this as java.lang.String).toCharArray()");
            List<PersonName> predNames = ((PersonNamePerceptron)object2).findPersonName((char[])object);
            goldTotal += goldNames.size();
            predTotal += predNames.size();
            for (PersonName x : predNames) {
                if (!goldNames.contains(x)) continue;
                ++correct;
            }
        }
        evaluate.1 prf$ = evaluate.1.INSTANCE;
        double[] result = prf$.invoke(goldTotal, predTotal, correct);
        long t2 = System.currentTimeMillis();
        String string = "\u6b63\u786e\u7387(P) %.2f , \u53ec\u56de\u7387(R) %.2f , F1 %.2f\n";
        objectArray = new Object[]{result[0], result[1], result[2]};
        object2 = System.out;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        object = string2;
        ((PrintStream)object2).println((String)object);
        string = "Evaluate use time " + (t2 - t1) + " ms";
        System.out.println((Object)string);
        return result;
    }

    private NREvaluate() {
    }

    static {
        NREvaluate nREvaluate;
        INSTANCE = nREvaluate = new NREvaluate();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/mayabot/nlp/segment/plugins/personname/NREvaluate$EvaluateSample;", "", "juzi", "", "goldNames", "", "Lcom/mayabot/nlp/segment/plugins/personname/PersonName;", "(Ljava/lang/String;Ljava/util/List;)V", "getGoldNames", "()Ljava/util/List;", "getJuzi", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "mynlp-segment"})
    public static final class EvaluateSample {
        @NotNull
        private final String juzi;
        @NotNull
        private final List<PersonName> goldNames;

        @NotNull
        public final String getJuzi() {
            return this.juzi;
        }

        @NotNull
        public final List<PersonName> getGoldNames() {
            return this.goldNames;
        }

        public EvaluateSample(@NotNull String juzi, @NotNull List<PersonName> goldNames) {
            Intrinsics.checkParameterIsNotNull((Object)juzi, (String)"juzi");
            Intrinsics.checkParameterIsNotNull(goldNames, (String)"goldNames");
            this.juzi = juzi;
            this.goldNames = goldNames;
        }

        @NotNull
        public final String component1() {
            return this.juzi;
        }

        @NotNull
        public final List<PersonName> component2() {
            return this.goldNames;
        }

        @NotNull
        public final EvaluateSample copy(@NotNull String juzi, @NotNull List<PersonName> goldNames) {
            Intrinsics.checkParameterIsNotNull((Object)juzi, (String)"juzi");
            Intrinsics.checkParameterIsNotNull(goldNames, (String)"goldNames");
            return new EvaluateSample(juzi, goldNames);
        }

        @NotNull
        public static /* synthetic */ EvaluateSample copy$default(EvaluateSample evaluateSample2, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = evaluateSample2.juzi;
            }
            if ((n & 2) != 0) {
                list = evaluateSample2.goldNames;
            }
            return evaluateSample2.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "EvaluateSample(juzi=" + this.juzi + ", goldNames=" + this.goldNames + ")";
        }

        public int hashCode() {
            String string = this.juzi;
            List<PersonName> list = this.goldNames;
            return (string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EvaluateSample)) break block3;
                    EvaluateSample evaluateSample2 = (EvaluateSample)object;
                    if (!Intrinsics.areEqual((Object)this.juzi, (Object)evaluateSample2.juzi) || !Intrinsics.areEqual(this.goldNames, evaluateSample2.goldNames)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

