/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.personname;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J.\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/mayabot/nlp/segment/plugins/personname/NRPerceptronFeature;", "", "()V", "CHAR_NULL", "", "addFeature", "", "features", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "vector", "Lcom/mayabot/nlp/hppc/IntArrayList;", "stringBuilder", "Lcom/mayabot/nlp/common/FastStringBuilder;", "extractFeature", "sentence", "", "size", "", "position", "callBack", "Ljava/util/function/Consumer;", "", "extractFeatureVector", "buffer", "mynlp-segment"})
public final class NRPerceptronFeature {
    private static final char CHAR_NULL = '\u0000';
    public static final NRPerceptronFeature INSTANCE;

    @NotNull
    public final IntArrayList extractFeatureVector(@NotNull char[] sentence, int size, int position, @NotNull FeatureSet features, @NotNull FastStringBuilder buffer) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull((Object)features, (String)"features");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        IntArrayList vector = new IntArrayList(8);
        int lastIndex = size - position - 1;
        char pre2Char = position > 1 ? sentence[position - 2] : (char)'\u0000';
        char preChar = position > 0 ? sentence[position - 1] : (char)'\u0000';
        char curChar = sentence[position];
        char nextChar = lastIndex > 0 ? sentence[position + 1] : (char)'\u0000';
        char next2Char = lastIndex > 1 ? sentence[position + 2] : (char)'\u0000';
        buffer.set2(curChar, '2');
        this.addFeature(features, vector, buffer);
        if (position > 0) {
            buffer.set2(preChar, '1');
            this.addFeature(features, vector, buffer);
            buffer.set4(preChar, '/', curChar, '5');
            this.addFeature(features, vector, buffer);
            if (position > 1) {
                buffer.set4(pre2Char, '/', preChar, '4');
                this.addFeature(features, vector, buffer);
            }
        }
        if (lastIndex > 0) {
            buffer.set2(nextChar, '3');
            this.addFeature(features, vector, buffer);
            buffer.set4(curChar, '/', nextChar, '6');
            this.addFeature(features, vector, buffer);
            if (lastIndex > 1) {
                buffer.set4(nextChar, '/', next2Char, '7');
                this.addFeature(features, vector, buffer);
            }
        }
        vector.add(0);
        return vector;
    }

    private final void addFeature(FeatureSet features, IntArrayList vector, FastStringBuilder stringBuilder) {
        int id = features.featureId(stringBuilder);
        stringBuilder.clear();
        if (id >= 0) {
            vector.add(id);
        }
    }

    public final void extractFeature(@NotNull char[] sentence, int size, int position, @NotNull Consumer<String> callBack) {
        String string;
        CharSequence charSequence;
        Consumer<String> consumer;
        String string2;
        char c;
        char next2Char;
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull(callBack, (String)"callBack");
        int lastIndex = size - position - 1;
        char pre2Char = position > 1 ? sentence[position - 2] : (char)'\u0000';
        char preChar = position > 0 ? sentence[position - 1] : (char)'\u0000';
        char curChar = sentence[position];
        char nextChar = lastIndex > 0 ? sentence[position + 1] : (char)'\u0000';
        char c2 = next2Char = lastIndex > 1 ? sentence[position + 2] : (char)'\u0000';
        if (position > 0) {
            c = preChar;
            string2 = "1";
            consumer = callBack;
            charSequence = String.valueOf(c) + string2;
            consumer.accept((String)charSequence);
        }
        c = curChar;
        string2 = "2";
        consumer = callBack;
        charSequence = String.valueOf(c) + string2;
        consumer.accept((String)charSequence);
        if (lastIndex > 0) {
            c = nextChar;
            string2 = "3";
            consumer = callBack;
            charSequence = String.valueOf(c) + string2;
            consumer.accept((String)charSequence);
        }
        if (position > 1) {
            c = pre2Char;
            string2 = "/";
            charSequence = new StringBuilder();
            consumer = callBack;
            string = String.valueOf(c) + string2;
            consumer.accept(((StringBuilder)charSequence).append(string).append(preChar).append("4").toString());
        }
        if (position > 0) {
            c = preChar;
            string2 = "/";
            charSequence = new StringBuilder();
            consumer = callBack;
            string = String.valueOf(c) + string2;
            consumer.accept(((StringBuilder)charSequence).append(string).append(curChar).append("5").toString());
        }
        if (lastIndex > 0) {
            c = curChar;
            string2 = "/";
            charSequence = new StringBuilder();
            consumer = callBack;
            string = String.valueOf(c) + string2;
            consumer.accept(((StringBuilder)charSequence).append(string).append(nextChar).append("6").toString());
        }
        if (lastIndex > 1) {
            c = nextChar;
            string2 = "/";
            charSequence = new StringBuilder();
            consumer = callBack;
            string = String.valueOf(c) + string2;
            consumer.accept(((StringBuilder)charSequence).append(string).append(next2Char).append("7").toString());
        }
    }

    private NRPerceptronFeature() {
    }

    static {
        NRPerceptronFeature nRPerceptronFeature;
        INSTANCE = nRPerceptronFeature = new NRPerceptronFeature();
    }
}

