/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.personname;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.TrainSample;
import com.mayabot.nlp.segment.plugins.personname.NRPerceptronFeature;
import com.mayabot.nlp.utils.CharNormUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0002J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0006J\u0016\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0017"}, d2={"Lcom/mayabot/nlp/segment/plugins/personname/NRPerceptronSample;", "", "()V", "forOnlineLearn", "", "ineInput", "", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "idOf", "tag", "loadSamples", "", "Lcom/mayabot/nlp/perceptron/TrainSample;", "allFiles", "Ljava/io/File;", "sample2Juzi", "line", "sample2JuziAndTag", "Lkotlin/Pair;", "", "text", "sentenceToSample", "mynlp-segment"})
public final class NRPerceptronSample {
    public static final NRPerceptronSample INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final int forOnlineLearn(@NotNull String ineInput, @NotNull FeatureSet featureSet) {
        void max;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)ineInput, (String)"ineInput");
        Intrinsics.checkParameterIsNotNull((Object)featureSet, (String)"featureSet");
        String string2 = string = this.sample2Juzi(ineInput);
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string2.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] sentence = cArray;
        CharNormUtils.convert(sentence);
        string = new Ref.IntRef();
        ((Ref.IntRef)string).element = 0;
        int n = 0;
        int n2 = sentence.length;
        while (n < n2) {
            void i;
            NRPerceptronFeature.INSTANCE.extractFeature(sentence, sentence.length, (int)i, new Consumer<String>(featureSet, (Ref.IntRef)max){
                final /* synthetic */ FeatureSet $featureSet;
                final /* synthetic */ Ref.IntRef $max;

                public final void accept(@NotNull String feature) {
                    int id;
                    Intrinsics.checkParameterIsNotNull((Object)feature, (String)"feature");
                    int fid = this.$featureSet.featureId(feature);
                    if (fid < 0 && (id = this.$featureSet.newExtId(feature)) > this.$max.element) {
                        this.$max.element = id;
                    }
                }
                {
                    this.$featureSet = featureSet;
                    this.$max = intRef;
                }
            });
            ++i;
        }
        return max.element;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String sample2Juzi(@NotNull String line) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)line, (String[])new String[]{"\ufe4d"}, (boolean)false, (int)0, (int)6, null);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Character c = Character.valueOf(it.charAt(0));
            collection.add(c);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<TrainSample> loadSamples(@NotNull List<? extends File> allFiles2, @NotNull FeatureSet featureSet) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Intrinsics.checkParameterIsNotNull(allFiles2, (String)"allFiles");
        Intrinsics.checkParameterIsNotNull((Object)featureSet, (String)"featureSet");
        int sampleSize = 0;
        Object $receiver$iv = allFiles2;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            File file = (File)element$iv;
            boolean bl = false;
            File $receiver$iv2 = file;
            Charset charset$iv = Charsets.UTF_8;
            Object object5 = $receiver$iv2;
            int n = 8192;
            object3 = object4 = object5;
            object4 = new InputStreamReader((InputStream)(object3 = (InputStream)new FileInputStream((File)object3)), charset$iv);
            object5 = object4 instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n);
            object2 = null;
            try {
                BufferedReader it$iv = (BufferedReader)object5;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl2 = false;
                Sequence $receiver$iv3 = it;
                for (Object element$iv2 : $receiver$iv3) {
                    String it2 = (String)element$iv2;
                    boolean bl3 = false;
                    CharSequence charSequence = it2;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    int n2 = sampleSize;
                    sampleSize = n2 + 1;
                }
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object5, (Throwable)object2);
            }
        }
        $receiver$iv = "Sample Size " + sampleSize;
        System.out.println($receiver$iv);
        ArrayList sampleList = new ArrayList(sampleSize / 5);
        Iterable $receiver$iv4 = allFiles2;
        for (Object element$iv : $receiver$iv4) {
            File file = (File)element$iv;
            boolean bl = false;
            File $receiver$iv5 = file;
            Charset charset$iv = Charsets.UTF_8;
            object2 = $receiver$iv5;
            int n = 8192;
            object = object3 = object2;
            object3 = new InputStreamReader((InputStream)(object = (InputStream)new FileInputStream((File)object)), charset$iv);
            object2 = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object4 = null;
            try {
                BufferedReader it$iv = (BufferedReader)object2;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl4 = false;
                Sequence $receiver$iv6 = lines;
                for (Object element$iv3 : $receiver$iv6) {
                    String line = (String)element$iv3;
                    boolean bl5 = false;
                    Object object6 = line;
                    if (!(!StringsKt.isBlank((CharSequence)object6))) continue;
                    object6 = sampleList;
                    TrainSample trainSample = INSTANCE.sentenceToSample(line, featureSet);
                    object6.add(trainSample);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object4);
            }
        }
        return sampleList;
    }

    @NotNull
    public final Pair<String, int[]> sample2JuziAndTag(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        StringBuilder stringBuilder = new StringBuilder();
        IntArrayList labels = new IntArrayList();
        Iterable $receiver$iv = StringsKt.split$default((CharSequence)text, (String[])new String[]{"\ufe4d"}, (boolean)false, (int)0, (int)6, null);
        for (Object element$iv : $receiver$iv) {
            String item = (String)element$iv;
            boolean bl = false;
            char zi = item.charAt(0);
            String lab = String.valueOf(item.charAt(1));
            stringBuilder.append(zi);
            labels.add(INSTANCE.idOf(lab));
        }
        String string = stringBuilder.toString();
        int[] nArray = labels.toArray();
        if (nArray == null) {
            Intrinsics.throwNpe();
        }
        return TuplesKt.to((Object)string, (Object)nArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TrainSample sentenceToSample(@NotNull String text, @NotNull FeatureSet featureSet) {
        void juziString;
        void var7_7;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)featureSet, (String)"featureSet");
        FastStringBuilder buffer = new FastStringBuilder(4);
        Pair<String, int[]> pair = this.sample2JuziAndTag(text);
        String string = (String)pair.component1();
        int[] tagList = (int[])pair.component2();
        void v0 = var7_7 = juziString;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = v0.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] juzi = cArray;
        int len = juzi.length;
        List list = new ArrayList();
        int n = 0;
        int n2 = len;
        while (n < n2) {
            void i;
            IntArrayList vec = NRPerceptronFeature.INSTANCE.extractFeatureVector(juzi, len, (int)i, featureSet, buffer);
            list.add(vec);
            ++i;
        }
        return new TrainSample(list, tagList);
    }

    private final int idOf(String tag) {
        int n;
        switch (tag) {
            case "B": {
                n = 0;
                break;
            }
            case "M": {
                n = 1;
                break;
            }
            case "E": {
                n = 2;
                break;
            }
            case "O": {
                n = 3;
                break;
            }
            case "X": {
                n = 4;
                break;
            }
            case "Y": {
                n = 5;
                break;
            }
            case "Z": {
                n = 6;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private NRPerceptronSample() {
    }

    static {
        NRPerceptronSample nRPerceptronSample;
        INSTANCE = nRPerceptronSample = new NRPerceptronSample();
    }
}

