/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.personname;

import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.segment.plugins.ner.PerceptronNerService;
import com.mayabot.nlp.segment.plugins.personname.PersonName;
import com.mayabot.nlp.segment.plugins.personname.PersonNamePerceptron;
import com.mayabot.nlp.utils.CharNormUtils;
import com.mayabot.t.google.common.io.Files;
import com.mayabot.t.google.inject.Inject;
import com.mayabot.t.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;

@Singleton
public class PerceptronPersonNameService {
    private PersonNamePerceptron perceptron;
    static InternalLogger logger = InternalLoggerFactory.getInstance(PerceptronNerService.class);

    @Inject
    public PerceptronPersonNameService(MynlpEnv mynlp) throws Exception {
        long t1 = System.currentTimeMillis();
        NlpResource parameterResource = mynlp.loadResource("person-name-model/parameter.bin");
        NlpResource featureResource = mynlp.loadResource("person-name-model/feature.txt");
        File temp = new File(mynlp.getCacheDir(), "ner");
        File featureDatFile = new File(temp, featureResource.hash() + ".personName.dat");
        Files.createParentDirs(featureDatFile);
        if (!featureDatFile.exists()) {
            FeatureSet featureSet = FeatureSet.readFromText(new BufferedInputStream(featureResource.openInputStream()));
            featureSet.save(featureDatFile, null);
        }
        this.perceptron = PersonNamePerceptron.load(parameterResource.openInputStream(), new FileInputStream(featureDatFile));
        long t2 = System.currentTimeMillis();
        logger.info("PerceptronPersonNameService load use " + (t2 - t1) + " ms");
    }

    public List<PersonName> findName(String sentence) {
        char[] chars = sentence.toCharArray();
        CharNormUtils.convert(chars);
        return this.perceptron.findPersonName(chars);
    }

    public List<PersonName> findName(char[] sentence) {
        return this.perceptron.findPersonName(sentence);
    }
}

