/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.personname;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.perceptron.TrainSample;
import com.mayabot.nlp.segment.plugins.personname.NRPerceptronFeature;
import com.mayabot.nlp.segment.plugins.personname.NRPerceptronSample;
import com.mayabot.nlp.segment.plugins.personname.PersonName;
import com.mayabot.nlp.segment.plugins.personname.PersonNamePerceptron;
import com.mayabot.nlp.utils.CharNormUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/mayabot/nlp/segment/plugins/personname/PersonNamePerceptron;", "", "model", "Lcom/mayabot/nlp/perceptron/Perceptron;", "(Lcom/mayabot/nlp/perceptron/Perceptron;)V", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "getModel", "()Lcom/mayabot/nlp/perceptron/Perceptron;", "compress", "", "ratio", "", "threshold", "decode", "", "sentence", "", "convert", "", "findPersonName", "", "Lcom/mayabot/nlp/segment/plugins/personname/PersonName;", "learn", "pre", "", "name", "last", "save", "dir", "Ljava/io/File;", "Companion", "mynlp-segment"})
public final class PersonNamePerceptron {
    private final FeatureSet featureSet;
    @NotNull
    private final Perceptron model;
    public static final int B = 0;
    public static final int E = 2;
    public static final int O = 3;
    @NotNull
    private static final List<String> tagList;
    public static final Companion Companion;

    public final void save(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        dir.mkdirs();
        this.model.save(dir);
    }

    public final void compress(double ratio, double threshold) {
        this.model.compress(ratio, threshold);
    }

    public final void learn(@Nullable String pre, @NotNull String name, @Nullable String last) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        learn.1 bindTag$ = learn.1.INSTANCE;
        learn.2 nrBindTag$ = learn.2.INSTANCE;
        ArrayList list = new ArrayList();
        if (pre != null) {
            list.addAll(bindTag$.invoke(pre, "X"));
        }
        Collection collection = list;
        Iterable iterable = nrBindTag$.invoke(name);
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        if (last != null) {
            list.addAll(bindTag$.invoke(last, "Y"));
        }
        String sentence = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\ufe4d", null, null, (int)0, null, null, (int)62, null);
        FeatureSet featureSet = this.model.featureSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)featureSet, (String)"model.featureSet()");
        int id = NRPerceptronSample.INSTANCE.forOnlineLearn(sentence, featureSet);
        this.model.makeSureParameter(id);
        FeatureSet featureSet2 = this.model.featureSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)featureSet2, (String)"model.featureSet()");
        TrainSample sample = NRPerceptronSample.INSTANCE.sentenceToSample(sentence, featureSet2);
        this.model.updateForOnlineLearn(sample);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PersonName> findPersonName(@NotNull char[] sentence) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        ArrayList result = new ArrayList();
        int[] decode = this.decode(sentence, false);
        int p = -1;
        int n = 0;
        int n2 = decode.length;
        while (n < n2) {
            void i;
            switch (decode[i]) {
                case 0: {
                    p = i;
                    break;
                }
                case 2: {
                    if (p == -1) break;
                    Collection collection = result;
                    void var8_9 = i - p + true;
                    String string = new String(sentence, p, (int)var8_9);
                    int n3 = p;
                    String string2 = string;
                    PersonName personName = new PersonName(string2, n3);
                    collection.add(personName);
                    p = -1;
                    break;
                }
                case 3: {
                    p = -1;
                }
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] decode(@NotNull char[] sentence, boolean convert) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        if (convert) {
            CharNormUtils.convert(sentence);
        }
        FastStringBuilder buffer = new FastStringBuilder(4);
        int size = sentence.length;
        ArrayList featureList = new ArrayList(size);
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            Collection collection = featureList;
            IntArrayList intArrayList = NRPerceptronFeature.INSTANCE.extractFeatureVector(sentence, size, (int)i, this.featureSet, buffer);
            collection.add(intArrayList);
            ++i;
        }
        int[] nArray = this.model.decode(featureList);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray, (String)"model.decode(featureList)");
        return nArray;
    }

    @NotNull
    public final Perceptron getModel() {
        return this.model;
    }

    public PersonNamePerceptron(@NotNull Perceptron model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this.model = model;
        FeatureSet featureSet = this.model.featureSet();
        if (featureSet == null) {
            Intrinsics.throwNpe();
        }
        this.featureSet = featureSet;
    }

    static {
        Companion = new Companion(null);
        tagList = CollectionsKt.listOf((Object[])new String[]{"B", "M", "E", "O", "X", "Y", "Z"});
    }

    @NotNull
    public static final List<String> getTagList() {
        Companion companion = Companion;
        return tagList;
    }

    @JvmStatic
    @NotNull
    public static final PersonNamePerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin) {
        return Companion.load(parameterBin, featureBin);
    }

    @JvmStatic
    @NotNull
    public static final PersonNamePerceptron load(@NotNull File dir) {
        return Companion.load(dir);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/mayabot/nlp/segment/plugins/personname/PersonNamePerceptron$Companion;", "", "()V", "B", "", "E", "O", "tagList", "", "", "tagList$annotations", "getTagList", "()Ljava/util/List;", "load", "Lcom/mayabot/nlp/segment/plugins/personname/PersonNamePerceptron;", "dir", "Ljava/io/File;", "parameterBin", "Ljava/io/InputStream;", "featureBin", "mynlp-segment"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void tagList$annotations() {
        }

        @NotNull
        public final List<String> getTagList() {
            return tagList;
        }

        @JvmStatic
        @NotNull
        public final PersonNamePerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin) {
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            Intrinsics.checkParameterIsNotNull((Object)featureBin, (String)"featureBin");
            PerceptronModel model = PerceptronModel.Companion.load(parameterBin, featureBin, true);
            return new PersonNamePerceptron(model);
        }

        @JvmStatic
        @NotNull
        public final PersonNamePerceptron load(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Object object = new File(dir, "parameter.bin");
            Companion companion = this;
            InputStream inputStream = new FileInputStream((File)object);
            object = inputStream;
            int n = 8192;
            inputStream = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            object = new File(dir, "feature.dat");
            inputStream = inputStream;
            InputStream inputStream2 = new FileInputStream((File)object);
            object = inputStream2;
            n = 8192;
            inputStream2 = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            return companion.load(inputStream, inputStream2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

