/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.pos;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.plugins.pos.POSPerceptronFeature;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0006J4\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001b2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020\u00060\u001fJ\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00110\u00110\u0005\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/mayabot/nlp/segment/plugins/pos/POSPerceptron;", "", "model", "Lcom/mayabot/nlp/perceptron/Perceptron;", "labelList", "", "", "(Lcom/mayabot/nlp/perceptron/Perceptron;[Ljava/lang/String;)V", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "kotlin.jvm.PlatformType", "getLabelList", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getModel", "()Lcom/mayabot/nlp/perceptron/Perceptron;", "natureList", "Lcom/mayabot/nlp/segment/Nature;", "getNatureList", "()[Lcom/mayabot/nlp/segment/Nature;", "[Lcom/mayabot/nlp/segment/Nature;", "parameter", "", "getParameter", "()[F", "decode", "word", "", "T", "sentence", "sink", "Ljava/util/function/Function;", "save", "", "dir", "Ljava/io/File;", "Companion", "mynlp-segment"})
public final class POSPerceptron {
    private final FeatureSet featureSet;
    @NotNull
    private final float[] parameter;
    @NotNull
    private final Nature[] natureList;
    @NotNull
    private final Perceptron model;
    @NotNull
    private final String[] labelList;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final float[] getParameter() {
        return this.parameter;
    }

    @NotNull
    public final Nature[] getNatureList() {
        return this.natureList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Nature> decode(@NotNull List<String> sentence) {
        void $receiver$iv$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        FastStringBuilder buffer = new FastStringBuilder(100);
        int size = sentence.size();
        ArrayList featureList = new ArrayList(size);
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            object = featureList;
            FeatureSet featureSet = this.featureSet;
            Intrinsics.checkExpressionValueIsNotNull((Object)featureSet, (String)"featureSet");
            IntArrayList intArrayList = POSPerceptronFeature.extractFeatureVector(sentence, size, (int)i, featureSet, buffer);
            object.add(intArrayList);
            ++i;
        }
        int[] result = this.model.decode(featureList);
        Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"result");
        int[] $receiver$iv = result;
        object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        void var9_11 = $receiver$iv$iv;
        int n3 = ((void)var9_11).length;
        for (int i = 0; i < n3; ++i) {
            void it;
            void item$iv$iv;
            void var13_15 = item$iv$iv = var9_11[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Nature nature = this.natureList[it];
            collection.add(nature);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<Nature> decode(@NotNull List<? extends T> sentence, @NotNull Function<T, String> sink) {
        void $receiver$iv$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull(sink, (String)"sink");
        int size = sentence.size();
        FastStringBuilder buffer = new FastStringBuilder(100);
        ArrayList featureList = new ArrayList(size);
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            object = featureList;
            FeatureSet featureSet = this.featureSet;
            Intrinsics.checkExpressionValueIsNotNull((Object)featureSet, (String)"featureSet");
            IntArrayList intArrayList = POSPerceptronFeature.extractFeatureVector2(sentence, size, (int)i, featureSet, sink, buffer);
            object.add(intArrayList);
            ++i;
        }
        int[] result = this.model.decode(featureList);
        Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"result");
        int[] $receiver$iv = result;
        object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        void var10_12 = $receiver$iv$iv;
        int n3 = ((void)var10_12).length;
        for (int i = 0; i < n3; ++i) {
            void it;
            void item$iv$iv;
            void var14_16 = item$iv$iv = var10_12[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Nature nature = this.natureList[it];
            collection.add(nature);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Nature decode(@NotNull String word) {
        int j;
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        int labelSize = this.labelList.length;
        FastStringBuilder buffer = new FastStringBuilder(50);
        List list = CollectionsKt.listOf((Object)word);
        FeatureSet featureSet = this.featureSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)featureSet, (String)"featureSet");
        IntArrayList vector = POSPerceptronFeature.extractFeatureVector(list, 1, 0, featureSet, buffer);
        int[] vectorBuffer = vector.buffer;
        int maxIndex = 0;
        double maxScore = DoubleCompanionObject.INSTANCE.getMIN_VALUE();
        int[] offset = new int[vector.size() - 1];
        int n = 0;
        int n2 = vector.size() - 1;
        while (n < n2) {
            int index = vectorBuffer[j];
            offset[j] = index * labelSize;
            ++j;
        }
        j = 0;
        n2 = labelSize;
        while (j < n2) {
            void label;
            double score = 0.0;
            int n3 = 0;
            int n4 = vector.size() - 1;
            while (n3 < n4) {
                void j2;
                score += (double)this.parameter[offset[j2] + label];
                ++j2;
            }
            if (score > maxScore) {
                maxIndex = label;
                maxScore = score;
            }
            ++label;
        }
        Nature nature = this.natureList[maxIndex];
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)nature), (String)"natureList[maxIndex]");
        return nature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull File dir) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        dir.mkdirs();
        this.model.save(dir);
        Object object2 = new File(dir, "label.txt");
        Object object3 = Charsets.UTF_8;
        int n = 8192;
        Object object4 = object = object2;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        BufferedWriter out = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        object2 = out;
        object3 = null;
        try {
            BufferedWriter it = (BufferedWriter)object2;
            boolean bl = false;
            it.write(ArraysKt.joinToString$default((Object[])this.labelList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
    }

    @NotNull
    public final Perceptron getModel() {
        return this.model;
    }

    @NotNull
    public final String[] getLabelList() {
        return this.labelList;
    }

    /*
     * WARNING - void declaration
     */
    public POSPerceptron(@NotNull Perceptron model, @NotNull String[] labelList) {
        Collection<Nature> collection;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)labelList, (String)"labelList");
        this.model = model;
        this.labelList = labelList;
        this.featureSet = this.model.featureSet();
        Perceptron perceptron = this.model;
        if (perceptron == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.mayabot.nlp.perceptron.PerceptronModel");
        }
        this.parameter = ((PerceptronModel)perceptron).getParameter();
        String[] stringArray = this.labelList;
        POSPerceptron pOSPerceptron = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
        void var6_7 = $receiver$iv$iv;
        int n = ((void)var6_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = var6_7[i];
            collection = destination$iv$iv;
            boolean bl = false;
            Nature nature = Nature.parse((String)it);
            collection.add(nature);
        }
        collection = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)collection;
        Nature[] natureArray = thisCollection$iv.toArray(new Nature[0]);
        if (natureArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = natureArray;
        pOSPerceptron.natureList = (Nature[])collection;
    }

    @JvmStatic
    @NotNull
    public static final POSPerceptron load(@NotNull File dir) {
        return Companion.load(dir);
    }

    @JvmStatic
    @NotNull
    public static final POSPerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText) {
        return Companion.load(parameterBin, featureBin, labelText);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/mayabot/nlp/segment/plugins/pos/POSPerceptron$Companion;", "", "()V", "load", "Lcom/mayabot/nlp/segment/plugins/pos/POSPerceptron;", "dir", "Ljava/io/File;", "parameterBin", "Ljava/io/InputStream;", "featureBin", "labelText", "mynlp-segment"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final POSPerceptron load(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Object object = new File(dir, "parameter.bin");
            object = new FileInputStream((File)object);
            int n = 8192;
            BufferedInputStream parameterBin = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Object object2 = new File(dir, "feature.dat");
            object2 = new FileInputStream((File)object2);
            int n2 = 8192;
            BufferedInputStream featureBin = object2 instanceof BufferedInputStream ? (BufferedInputStream)object2 : new BufferedInputStream((InputStream)object2, n2);
            Object object3 = new File(dir, "label.txt");
            object3 = new FileInputStream((File)object3);
            int n3 = 8192;
            BufferedInputStream labelText = object3 instanceof BufferedInputStream ? (BufferedInputStream)object3 : new BufferedInputStream((InputStream)object3, n3);
            return this.load(parameterBin, featureBin, labelText);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final POSPerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText) {
            String[] stringArray;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            Intrinsics.checkParameterIsNotNull((Object)featureBin, (String)"featureBin");
            Intrinsics.checkParameterIsNotNull((Object)labelText, (String)"labelText");
            PerceptronModel model = PerceptronModel.Companion.load(parameterBin, featureBin, true);
            model.setDecodeQuickModel(true);
            Object object = labelText;
            Throwable throwable = null;
            try {
                Object it = (InputStream)object;
                boolean bl = false;
                InputStream inputStream = it;
                Charset charset = Charsets.UTF_8;
                Closeable closeable = inputStream;
                closeable = new InputStreamReader((InputStream)closeable, charset);
                int n = 8192;
                it = TextStreamsKt.readLines((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Object labelList = it;
            object = (Collection)labelList;
            Perceptron perceptron = model;
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v0;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray3 = stringArray = stringArray2;
            Perceptron perceptron2 = perceptron;
            return new POSPerceptron(perceptron2, stringArray3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

