/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.pos;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.DATFeatureSetBuilder;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronTrainer;
import com.mayabot.nlp.perceptron.TrainSample;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.common.PerceptronUtilsKt;
import com.mayabot.nlp.segment.common.PkuWord;
import com.mayabot.nlp.segment.plugins.pos.POSEvaluateRunner;
import com.mayabot.nlp.segment.plugins.pos.POSPerceptron;
import com.mayabot.nlp.segment.plugins.pos.POSPerceptronFeature;
import com.mayabot.nlp.utils.CharNormUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/mayabot/nlp/segment/plugins/pos/POSPerceptronTrainer;", "", "()V", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "getFeatureSet", "()Lcom/mayabot/nlp/perceptron/FeatureSet;", "setFeatureSet", "(Lcom/mayabot/nlp/perceptron/FeatureSet;)V", "labelMap", "", "", "", "getLabelMap", "()Ljava/util/Map;", "loadSamples", "", "Lcom/mayabot/nlp/perceptron/TrainSample;", "files", "Ljava/io/File;", "prepareFeatureSet", "", "corposFiles", "train", "Lcom/mayabot/nlp/segment/plugins/pos/POSPerceptron;", "trainFile", "evaluate", "maxIter", "threadNumber", "mynlp-segment"})
public final class POSPerceptronTrainer {
    @NotNull
    public FeatureSet featureSet;
    @NotNull
    private final Map<String, Integer> labelMap;

    @NotNull
    public final FeatureSet getFeatureSet() {
        FeatureSet featureSet = this.featureSet;
        if (featureSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureSet");
        }
        return featureSet;
    }

    public final void setFeatureSet(@NotNull FeatureSet featureSet) {
        Intrinsics.checkParameterIsNotNull((Object)featureSet, (String)"<set-?>");
        this.featureSet = featureSet;
    }

    @NotNull
    public final Map<String, Integer> getLabelMap() {
        return this.labelMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final POSPerceptron train(@NotNull File trainFile, @NotNull File evaluate2, int maxIter, int threadNumber) {
        String[] stringArray;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)trainFile, (String)"trainFile");
        Intrinsics.checkParameterIsNotNull((Object)evaluate2, (String)"evaluate");
        List<File> allFiles2 = PerceptronUtilsKt.allFiles(trainFile);
        this.prepareFeatureSet(allFiles2);
        StringBuilder stringBuilder = new StringBuilder().append("Feature Set Size ");
        FeatureSet featureSet = this.featureSet;
        if (featureSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureSet");
        }
        String string = stringBuilder.append(featureSet.size()).toString();
        System.out.println((Object)string);
        List<TrainSample> sampleList = this.loadSamples(allFiles2);
        List<TrainSample> evaluateSampleList = Intrinsics.areEqual((Object)evaluate2, (Object)trainFile) ? sampleList : this.loadSamples(PerceptronUtilsKt.allFiles(evaluate2));
        String string2 = "Start Train ... ";
        System.out.println((Object)string2);
        FeatureSet featureSet2 = this.featureSet;
        if (featureSet2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureSet");
        }
        PerceptronTrainer trainer2 = new PerceptronTrainer(featureSet2, this.labelMap.size(), sampleList, new POSEvaluateRunner(evaluateSampleList), maxIter, true);
        Perceptron model = trainer2.train(threadNumber);
        Object object = "--------------------";
        System.out.println(object);
        new POSEvaluateRunner(evaluateSampleList).run(0, model);
        object = CollectionsKt.sorted((Iterable)this.labelMap.keySet());
        Perceptron perceptron = model;
        void v3 = $receiver$iv;
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v3;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray = stringArray2;
        Perceptron perceptron2 = perceptron;
        return new POSPerceptron(perceptron2, stringArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<TrainSample> loadSamples(@NotNull List<? extends File> files) {
        Object it$iv2;
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Function1<List<? extends PkuWord>, TrainSample> sentenceToSample$ = new Function1<List<? extends PkuWord>, TrainSample>(this){
            final /* synthetic */ POSPerceptronTrainer this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final TrainSample invoke(@NotNull List<PkuWord> line) {
                void $receiver$iv$iv3;
                Object object;
                Collection collection;
                Object object2;
                void $receiver$iv$iv2;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull(line, (String)"line");
                FastStringBuilder buffer = new FastStringBuilder(100);
                Iterable iterable = $receiver$iv = (Iterable)line;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv2) {
                    void it;
                    object2 = (PkuWord)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    object = it.getWord();
                    collection.add(object);
                }
                List words = (List)destination$iv$iv;
                Iterable $receiver$iv2 = line;
                destination$iv$iv = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (T item$iv$iv : $receiver$iv$iv3) {
                    void it;
                    PkuWord bl = (PkuWord)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Integer n = this.this$0.getLabelMap().get(it.getPos());
                    if (n == null) {
                        Intrinsics.throwNpe();
                    }
                    object = ((Number)n).intValue();
                    collection.add(object);
                }
                int[] poss = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv2));
                ArrayList<E> featureMatrix = new ArrayList<E>(words.size());
                int $receiver$iv$iv3 = 0;
                int n = words.size();
                while ($receiver$iv$iv3 < n) {
                    void i;
                    Collection collection2 = featureMatrix;
                    object2 = POSPerceptronFeature.extractFeatureVector(words, words.size(), (int)i, this.this$0.getFeatureSet(), buffer);
                    collection2.add(object2);
                    ++i;
                }
                return new TrainSample((List<? extends IntArrayList>)featureMatrix, poss);
            }
            {
                this.this$0 = pOSPerceptronTrainer;
                super(1);
            }
        };
        int sampleSize = 0;
        Object $receiver$iv = files;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            File file = (File)element$iv;
            boolean bl = false;
            File $receiver$iv2 = file;
            Charset charset$iv = Charsets.UTF_8;
            Object object3 = $receiver$iv2;
            int n = 8192;
            object = object2 = object3;
            object2 = new InputStreamReader((InputStream)(object = (InputStream)new FileInputStream((File)object)), charset$iv);
            object3 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            Throwable throwable = null;
            try {
                it$iv2 = (BufferedReader)object3;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv2);
                boolean bl2 = false;
                Sequence $receiver$iv3 = it;
                for (Object element$iv2 : $receiver$iv3) {
                    String line = (String)element$iv2;
                    boolean bl3 = false;
                    CharSequence charSequence = line;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    int n2 = sampleSize;
                    sampleSize = n2 + 1;
                }
                it$iv2 = Unit.INSTANCE;
            }
            catch (Throwable it$iv2) {
                throwable = it$iv2;
                throw it$iv2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
        }
        $receiver$iv = "Will load " + sampleSize + " Sample";
        System.out.println($receiver$iv);
        ArrayList sampleList = new ArrayList(sampleSize + 10);
        int count = 0;
        System.out.print("Load 0%");
        Iterable $receiver$iv4 = files;
        for (Object element$iv : $receiver$iv4) {
            File file = (File)element$iv;
            boolean bl = false;
            File $receiver$iv5 = file;
            Charset charset$iv = Charsets.UTF_8;
            object2 = $receiver$iv5;
            int n = 8192;
            Object object4 = it$iv2 = object2;
            it$iv2 = new InputStreamReader((InputStream)(object4 = (InputStream)new FileInputStream((File)object4)), charset$iv);
            object2 = it$iv2 instanceof BufferedReader ? (BufferedReader)it$iv2 : new BufferedReader((Reader)it$iv2, n);
            object = null;
            try {
                BufferedReader it$iv3 = (BufferedReader)object2;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv3);
                boolean bl4 = false;
                Sequence $receiver$iv6 = lines;
                for (Object element$iv3 : $receiver$iv6) {
                    String string;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv7;
                    String line = (String)element$iv3;
                    boolean bl5 = false;
                    Iterable $i$f$forEach = $receiver$iv7 = (Iterable)PerceptronUtilsKt.parseToFlatWords(line);
                    Collection destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        PkuWord it = (PkuWord)element$iv$iv;
                        boolean bl6 = false;
                        CharSequence charSequence = it.getWord();
                        if (!(charSequence.length() > 0 && Intrinsics.areEqual((Object)it.getPos(), (Object)"") ^ true)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List words = (List)destination$iv$iv;
                    $receiver$iv7 = words;
                    for (Object element$iv4 : $receiver$iv7) {
                        PkuWord it = (PkuWord)element$iv4;
                        boolean bl7 = false;
                        String string2 = CharNormUtils.convert(it.getWord());
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"CharNormUtils.convert(it.word)");
                        it.setWord(string2);
                    }
                    Collection collection = sampleList;
                    Object[] objectArray = sentenceToSample$.invoke((List<PkuWord>)words);
                    collection.add(objectArray);
                    int n3 = count;
                    if ((count = n3 + 1) % 100 != 0) continue;
                    String string3 = "%.2f";
                    objectArray = new Object[]{(double)count * 100.0 / (double)sampleList.size()};
                    StringBuilder stringBuilder = new StringBuilder().append("\rLoad ");
                    PrintStream printStream = System.out;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                    printStream.print(stringBuilder.append(string).append('%').toString());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
        }
        System.out.print("\r");
        return sampleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void prepareFeatureSet(List<? extends File> corposFiles) {
        String string = "\u5f00\u59cb\u6784\u5efaPOS FeatureSet";
        System.out.println((Object)string);
        long t1 = System.currentTimeMillis();
        DATFeatureSetBuilder builder = new DATFeatureSetBuilder(this.labelMap.size());
        Consumer fit2 = new Consumer<String>(builder){
            final /* synthetic */ DATFeatureSetBuilder $builder;

            public final void accept(@NotNull String f) {
                Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                this.$builder.put(f);
            }
            {
                this.$builder = dATFeatureSetBuilder;
            }
        };
        Iterable $receiver$iv = corposFiles;
        for (Object element$iv : $receiver$iv) {
            Object object;
            File file = (File)element$iv;
            boolean bl = false;
            String string2 = file.getAbsolutePath();
            System.out.println((Object)string2);
            File $receiver$iv2 = file;
            Charset charset$iv = Charsets.UTF_8;
            Object object2 = $receiver$iv2;
            int n = 8192;
            Object object3 = object = object2;
            object3 = new FileInputStream((File)object3);
            object = new InputStreamReader((InputStream)object3, charset$iv);
            object2 = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)object2;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl2 = false;
                Sequence $receiver$iv3 = lines;
                for (Object element$iv2 : $receiver$iv3) {
                    String it;
                    Iterable $receiver$iv$iv;
                    Iterable $receiver$iv4;
                    String line = (String)element$iv2;
                    boolean bl3 = false;
                    List<PkuWord> flatWords = PerceptronUtilsKt.parseToFlatWords(line);
                    Iterable iterable = $receiver$iv4 = (Iterable)flatWords;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        PkuWord pkuWord = (PkuWord)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        String string3 = CharNormUtils.convert(((PkuWord)((Object)it)).getWord());
                        collection.add(string3);
                    }
                    $receiver$iv4 = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv4;
                    destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        it = (String)element$iv$iv;
                        boolean bl5 = false;
                        String string4 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
                        CharSequence charSequence = string4;
                        if (!(charSequence.length() > 0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List words = (List)destination$iv$iv;
                    int $receiver$iv22 = 0;
                    int n2 = words.size();
                    while ($receiver$iv22 < n2) {
                        void i;
                        POSPerceptronFeature.extractFeature(words, words.size(), (int)i, fit2);
                        ++i;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        String string5 = "Start build featureSet ...";
        System.out.println((Object)string5);
        this.featureSet = builder.build();
        string5 = "FeatureSet\u6784\u5efa\u5b8c\u6210,\u7528\u65f6" + (System.currentTimeMillis() - t1) + "ms";
        System.out.println((Object)string5);
    }

    /*
     * WARNING - void declaration
     */
    public POSPerceptronTrainer() {
        Object $receiver$iv$iv;
        Object $receiver$iv = Nature.values();
        Nature[] natureArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv;
        int n = ((void)iterator).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = iterator[i];
            boolean bl = false;
            if (!(it != Nature.newWord && it != Nature.begin && it != Nature.end)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            Nature nature = (Nature)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.name();
            collection.add(string);
        }
        List list = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        HashMap map = new HashMap(Nature.values().length * 3);
        Iterable $receiver$iv2 = CollectionsKt.zip((Iterable)list, (Iterable)((Iterable)RangesKt.until((int)0, (int)list.size())));
        for (Object element$iv : $receiver$iv2) {
            Pair x = (Pair)element$iv;
            boolean bl = false;
            Map map2 = map;
            Object object = x.getFirst();
            Object object2 = x.getSecond();
            map2.put(object, object2);
        }
        this.labelMap = map;
    }
}

