/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.pos;

import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordpathProcessor;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.plugins.pos.PerceptronPosService;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordpath;
import com.mayabot.t.google.common.collect.Lists;
import com.mayabot.t.google.inject.Inject;
import com.mayabot.t.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class PosPerceptronProcessor
extends BaseSegmentComponent
implements WordpathProcessor {
    private final PerceptronPosService perceptronPosService;

    @Inject
    PosPerceptronProcessor(PerceptronPosService perceptronPosService) {
        this.setOrder(10000);
        this.perceptronPosService = perceptronPosService;
    }

    @Override
    public Wordpath process(Wordpath wordPath) {
        ArrayList<Vertex> vertices = Lists.newArrayList(wordPath.iteratorVertex());
        List<Nature> posList = this.perceptronPosService.posFromVertex(vertices);
        for (int i = 0; i < vertices.size(); ++i) {
            Vertex vertex = vertices.get(i);
            if (vertex.nature != null && vertex.nature != Nature.newWord) continue;
            vertex.nature = posList.get(i);
        }
        return wordPath;
    }
}

