/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.wordnet;

import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.t.google.common.collect.AbstractIterator;
import com.mayabot.t.google.common.collect.Lists;
import com.mayabot.t.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class VertexRow
implements Iterable<Vertex> {
    int rowNum;
    Vertex first;
    Wordnet wordnet;
    int size;

    VertexRow(int rowNum, Wordnet wordnet) {
        this.rowNum = rowNum;
        this.wordnet = wordnet;
    }

    public String subString(int length) {
        if (this.rowNum == -1 || length == 0) {
            return "";
        }
        return new String(this.wordnet.charArray, this.rowNum, length);
    }

    public Vertex getOrCrete(int length) {
        Vertex v = this.get(length);
        if (v == null) {
            v = new Vertex(length);
            this.put(v);
        }
        return v;
    }

    public void clear() {
        this.size = 0;
        this.first = null;
    }

    public Vertex get(int length) {
        if (this.first == null) {
            return null;
        }
        if (this.size == 1) {
            if (this.first.length == length) {
                return this.first;
            }
            return null;
        }
        Vertex x = this.first;
        while (x != null) {
            if (x.length == length) {
                return x;
            }
            if (length < x.length) {
                return null;
            }
            x = x.next;
        }
        return null;
    }

    public Vertex remove(short length) {
        Vertex v = this.get(length);
        if (v != null) {
            this.unlink(v);
        }
        return v;
    }

    public Vertex put(Vertex v) {
        int key = v.length;
        v.vertexRow = this;
        v.next = null;
        v.prev = null;
        if (this.isEmpty()) {
            this.linkFirst(v);
            return null;
        }
        Vertex point = null;
        Vertex x = this.first;
        while (x != null) {
            point = x;
            if (key == x.length) {
                this.replace(x, v);
                return x;
            }
            if (x.next == null) {
                if (key < x.length) {
                    this.linkBefore(v, x);
                    return null;
                }
                this.linkAfter(v, x);
                return null;
            }
            if (key < x.length) {
                this.linkBefore(v, x);
                return null;
            }
            if (key < x.next.length) {
                this.linkBefore(v, x.next);
                return null;
            }
            x = x.next;
        }
        this.linkAfter(v, point);
        return null;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public boolean contains(int len) {
        return this.get(len) != null;
    }

    public int size() {
        return this.size;
    }

    public Set<Integer> keys() {
        TreeSet<Integer> set = Sets.newTreeSet();
        Vertex x = this.first;
        while (x != null) {
            set.add(x.length);
            x = x.next;
        }
        return set;
    }

    public int lastLen() {
        int len = 0;
        Vertex x = this.first;
        while (x != null) {
            len = x.length;
            x = x.next;
        }
        return len;
    }

    private Vertex unlink(Vertex x) {
        Vertex next = x.next;
        Vertex prev = x.prev;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
            x.prev = null;
        }
        if (next != null) {
            next.prev = prev;
            x.next = null;
        }
        --this.size;
        return x;
    }

    private void replace(Vertex old, Vertex replaced) {
        Vertex prev = old.prev;
        Vertex next = old.next;
        old.prev = null;
        old.next = null;
        replaced.prev = prev;
        replaced.next = next;
        if (prev != null) {
            prev.next = replaced;
        }
        if (next != null) {
            next.prev = replaced;
        }
        if (this.first == old) {
            this.first = replaced;
        }
    }

    private void linkFirst(Vertex newNode) {
        Vertex f;
        newNode.next = null;
        newNode.prev = null;
        newNode.next = f = this.first;
        this.first = newNode;
        if (f != null) {
            f.prev = newNode;
        }
        ++this.size;
    }

    private void linkAfter(Vertex newNode, Vertex succ) {
        Vertex nexted = succ.next;
        newNode.prev = succ;
        newNode.next = nexted;
        succ.next = newNode;
        if (nexted != null) {
            nexted.prev = newNode;
        }
        ++this.size;
    }

    private void linkBefore(Vertex newNode, Vertex succ) {
        Vertex pred;
        newNode.prev = pred = succ.prev;
        newNode.next = succ;
        succ.prev = newNode;
        if (pred == null) {
            this.first = newNode;
        } else {
            pred.next = newNode;
        }
        ++this.size;
    }

    public String toString() {
        return "Slot[" + this.rowNum + "]=>" + this.keys();
    }

    @Override
    public Iterator<Vertex> iterator() {
        return new AbstractIterator<Vertex>(){
            Vertex point;
            {
                this.point = VertexRow.this.first;
            }

            @Override
            protected Vertex computeNext() {
                if (this.point == null) {
                    return (Vertex)this.endOfData();
                }
                Vertex old = this.point;
                this.point = old.next;
                return old;
            }
        };
    }

    public List<Vertex> values() {
        return Lists.newArrayList(this);
    }

    public Vertex getFirst() {
        return this.first;
    }

    public Vertex first() {
        return this.first;
    }

    public char theChar() {
        return this.wordnet.charAt(this.rowNum);
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public boolean isNotEmpty() {
        return this.first != null;
    }
}

