/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.wordnet;

import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.VertexRow;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import java.util.BitSet;
import org.fusesource.jansi.Ansi;

class WordNetToStringBuilder {
    private Wordnet wordnet;
    private boolean showAttr;

    WordNetToStringBuilder(Wordnet wordnet, boolean showAttr) {
        this.wordnet = wordnet;
        this.showAttr = showAttr;
    }

    public String toString() {
        BitSet noover = this.wordnet.findNoOverWords();
        StringBuilder sb = new StringBuilder();
        char[] text = this.wordnet.getCharArray();
        for (int i = -1; i <= this.wordnet.getCharSizeLength(); ++i) {
            StringBuilder line = new StringBuilder();
            VertexRow row = this.wordnet.row(i);
            char _char = '\u0000';
            _char = i >= 0 && i < text.length ? text[i] : (i == -1 ? (char)'\u00a4' : '\u00b6');
            line.append(String.format("@|cyan %d|@\t@|green %c |@", i, Character.valueOf(_char)));
            line.append("\t@|yellow ||@\t");
            if (row.isEmpty()) {
                if (noover.get(i)) {
                    line.append("\t@|green NULL|@");
                } else {
                    line.append("\t@|red NULL|@");
                }
            } else if (i == -1) {
                line.append("\t@|green BEGIN|@");
            } else if (i >= text.length) {
                line.append("\t@|green END|@");
            } else {
                int count = 0;
                for (Vertex v : row) {
                    line.append("\t");
                    if (count > 0) {
                        line.append("\t");
                    }
                    line.append(text, i, v.length);
                    if (v.isAbsWord()) {
                        line.append("[").append(v.absWordLabel()).append("]");
                    }
                    if (this.showAttr && v.nature != null) {
                        line.append(" ").append((Object)v.nature);
                    }
                    if (v.weight != 0.0) {
                        line.append("(").append(v.weight).append(")");
                    }
                    ++count;
                }
            }
            sb.append((CharSequence)line).append("\n");
        }
        try {
            Ansi ansi = Ansi.ansi();
            return ansi.eraseScreen().render(sb.toString()).toString();
        }
        catch (Throwable e) {
            return sb.toString().replaceAll("@\\|\\w+? (.+?)\\|@", "$1");
        }
    }
}

