/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.wordnet;

import com.mayabot.nlp.segment.common.VertexHelper;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.VertexRow;
import com.mayabot.nlp.segment.wordnet.WordNetToStringBuilder;
import com.mayabot.nlp.utils.CustomCharSequence;
import java.util.BitSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class Wordnet
implements CharSequence {
    private final VertexRow[] slotList;
    private final VertexRow begin;
    private final VertexRow end;
    final char[] charArray;
    private final int charSize;

    public Wordnet(char[] charArray) {
        this.charArray = charArray;
        this.charSize = charArray.length;
        this.begin = new VertexRow(-1, this);
        this.end = new VertexRow(this.charSize, this);
        this.slotList = new VertexRow[this.charSize];
        for (int i = 0; i < this.charSize; ++i) {
            this.slotList[i] = new VertexRow(i, this);
        }
        this.getBeginRow().put(VertexHelper.newBegin());
        this.getEndRow().put(VertexHelper.newEnd());
    }

    public void fillNill() {
        for (VertexRow row : this.slotList) {
            if (row.first != null) continue;
            Vertex vertex = row.getOrCrete(1);
            vertex.freq = 1;
        }
    }

    public BitSet findNoOverWords() {
        BitSet noOverWords = new BitSet();
        for (int i = 0; i < this.charSize; ++i) {
            VertexRow row = this.slotList[i];
            if (row == null) continue;
            Vertex p = row.first();
            while (p != null) {
                noOverWords.set(row.rowNum, row.rowNum + p.length);
                p = p.next;
            }
        }
        return noOverWords;
    }

    public BitSet findDangling() {
        int i;
        BitSet bitSet = new BitSet(this.charSize);
        BitSet noOverWords = this.findNoOverWords();
        bitSet.set(0);
        for (i = 0; i < this.charSize; ++i) {
            VertexRow row = this.slotList[i];
            if (row == null) continue;
            Vertex p = row.first();
            while (p != null) {
                noOverWords.set(row.rowNum + p.length);
                p = p.next;
            }
        }
        for (i = 0; i < this.charSize; ++i) {
            if (bitSet.get(i) || noOverWords.get(i)) continue;
            bitSet.set(i);
        }
        return null;
    }

    public final VertexRow getRow(int sindex) {
        return this.indexAt(sindex);
    }

    public final VertexRow row(int sindex) {
        return this.indexAt(sindex);
    }

    public int size() {
        int count = 0;
        for (int i = this.charSize - 1; i >= 0; --i) {
            VertexRow r = this.slotList[i];
            if (r == null) continue;
            count += r.size();
        }
        count += this.begin.size();
        return count += this.end.size();
    }

    private VertexRow indexAt(int sindex) {
        if (sindex == -1) {
            return this.begin;
        }
        if (sindex == this.charSize) {
            return this.end;
        }
        return this.slotList[sindex];
    }

    public int notNullRowNums() {
        int count = 0;
        for (int i = this.charSize - 1; i >= 0; --i) {
            VertexRow r = this.slotList[i];
            if (r == null || r.isEmpty()) continue;
            ++count;
        }
        if (!this.begin.isEmpty()) {
            ++count;
        }
        if (!this.end.isEmpty()) {
            ++count;
        }
        return count;
    }

    public Vertex put(int charOffset, Vertex vertex) {
        return this.getRow(charOffset).put(vertex);
    }

    public Vertex put(int offset, int length) {
        Vertex vertex = new Vertex(length);
        this.getRow(offset).put(vertex);
        return vertex;
    }

    public Vertex getRowFirst(int sindex) {
        VertexRow row = this.row(sindex);
        return row.getFirst();
    }

    public Vertex getVertex(int sindex, int length) {
        VertexRow row = this.row(sindex);
        return row.get(length);
    }

    public boolean isNotContains(int sindex, int length) {
        VertexRow row = this.row(sindex);
        return !row.contains(length);
    }

    public int sizeInRow(int sindex) {
        VertexRow row = this.row(sindex);
        if (row == null) {
            return 0;
        }
        return row.size();
    }

    public final void accessAllVertex(Consumer<Vertex> consumer) {
        for (int i = this.slotList.length - 1; i >= 0; --i) {
            VertexRow row = this.slotList[i];
            if (row == null) continue;
            for (Vertex v = row.first(); v != null; v = v.next()) {
                consumer.accept(v);
            }
        }
    }

    @Override
    public String toString() {
        return new WordNetToStringBuilder(this, false).toString();
    }

    public String toMoreString() {
        return new WordNetToStringBuilder(this, true).toString();
    }

    public VertexRow getBeginRow() {
        return this.begin;
    }

    public VertexRow getEndRow() {
        return this.end;
    }

    public int getCharSizeLength() {
        return this.charSize;
    }

    @NotNull
    public char[] getCharArray() {
        return this.charArray;
    }

    @Override
    public int length() {
        return this.charArray.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0) {
            return ' ';
        }
        if (index >= this.charSize) {
            return ' ';
        }
        return this.charArray[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CustomCharSequence(this.charArray, start, end - start);
    }

    public VertexRow[] getSlotList() {
        return this.slotList;
    }
}

