/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.wordnet;

import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.t.google.common.collect.AbstractIterator;
import com.mayabot.t.google.common.collect.ImmutableList;
import com.mayabot.t.google.common.collect.Iterables;
import java.util.BitSet;
import java.util.Iterator;
import java.util.function.Consumer;

public class Wordpath {
    static InternalLogger logger = InternalLoggerFactory.getInstance(Wordpath.class);
    private BitSet bitSet;
    private int length;
    private Wordnet wordnet;

    public Wordpath(Wordnet wordnet) {
        this.wordnet = wordnet;
        this.length = wordnet.length();
        this.bitSet = new BitSet(this.length);
        this.bitSet.set(0, this.length);
    }

    public Wordnet getWordnet() {
        return this.wordnet;
    }

    public Iterable<Vertex> getBestPathWithBE() {
        ImmutableList<Vertex> b = ImmutableList.of(this.wordnet.getBeginRow().getFirst());
        Iterable m = this::iteratorVertex;
        ImmutableList<Vertex> e = ImmutableList.of(this.wordnet.getEndRow().getFirst());
        return Iterables.concat(b, m, e);
    }

    public Iterator<Vertex> iteratorVertex() {
        return new AbstractIterator<Vertex>(){
            private WordPointer pointer;
            {
                this.pointer = Wordpath.this.wordPointer();
            }

            @Override
            protected Vertex computeNext() {
                boolean hasNext = this.pointer.next();
                if (!hasNext) {
                    return (Vertex)this.endOfData();
                }
                int from = this.pointer.getFrom();
                int len = this.pointer.getLen();
                Vertex theVertex = Wordpath.this.wordnet.getVertex(from, len);
                if (theVertex == null) {
                    logger.error("row: " + from + " len " + len + " select is null");
                    throw new IllegalStateException("row: " + from + " len " + len + " select is null");
                }
                return theVertex;
            }
        };
    }

    public Vertex combine(int from, int length) {
        this.connect(from, length);
        if (this.wordnet.isNotContains(from, length)) {
            return this.wordnet.put(from, length);
        }
        return this.wordnet.getVertex(from, length);
    }

    public void combine(Vertex vertex) {
        this.connect(vertex.getRowNum(), vertex.length());
    }

    public void findunloadVertext(Consumer<Vertex> consumer) {
        int lastIndex = this.length - 1;
        int i = 0;
        while (i < this.length) {
            int nextSplitIndex = this.bitSet.nextSetBit(i);
            if (i == lastIndex) {
                if (this.wordnet.isNotContains(i, 1)) {
                    consumer.accept(this.wordnet.put(i, 1));
                }
                ++i;
                continue;
            }
            int len = nextSplitIndex - i + 1;
            if (this.wordnet.isNotContains(i, len)) {
                consumer.accept(this.wordnet.put(i, len));
            }
            i += len;
        }
    }

    public int wordCount() {
        return this.bitSet.cardinality();
    }

    public int wordCountInPath() {
        return this.wordCount();
    }

    public WordPointer wordPointer() {
        return new WordPointer();
    }

    private void connect(int from, int length) {
        if (length <= 0 || from < 0) {
            return;
        }
        if (from > 0) {
            this.bitSet.set(from - 1);
        }
        this.bitSet.set(from + length - 1);
        this.bitSet.set(from, from + length - 1, false);
    }

    public boolean willCutOtherWords(int from, int len) {
        if (from != 0 && !this.bitSet.get(from - 1)) {
            return true;
        }
        int to = from + len - 1;
        return !this.bitSet.get(to);
    }

    public String toString() {
        int last = this.bitSet.length() - 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.wordnet.length(); ++i) {
            sb.append(this.wordnet.charAt(i));
            if (!this.bitSet.get(i) || i == last) continue;
            sb.append(" | ");
        }
        return sb.toString();
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    public void reset() {
        this.bitSet.set(0, this.length);
    }

    public class WordPointer {
        private int from;
        private int len;
        private final int lastIndex;
        private int i;

        public WordPointer() {
            this.lastIndex = Wordpath.this.length - 1;
            this.i = 0;
        }

        public int getFrom() {
            return this.from;
        }

        public int getLen() {
            return this.len;
        }

        public boolean next() {
            int nextSplitIndex = Wordpath.this.bitSet.nextSetBit(this.i);
            if (this.i >= Wordpath.this.length) {
                return false;
            }
            if (this.i == this.lastIndex) {
                this.from = this.i++;
                this.len = 1;
            } else {
                int le = nextSplitIndex - this.i + 1;
                this.from = this.i;
                this.len = le;
                this.i += le;
            }
            return true;
        }
    }
}

