/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.utils;

import com.mayabot.t.google.common.base.Charsets;
import com.mayabot.t.google.common.collect.Lists;
import com.mayabot.t.google.common.collect.Sets;
import com.mayabot.t.google.common.io.Resources;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CharNormUtils {
    private static char[] table = new char[65535];

    public static char convert(char input) {
        char c = table[input];
        if (c != '\u0000') {
            return c;
        }
        return input;
    }

    public static void convert(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            char to = table[c];
            if (to == '\u0000') continue;
            chars[i] = to;
        }
    }

    public static String convert(String input) {
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            char to = table[c];
            if (to == '\u0000') continue;
            chars[i] = to;
        }
        return new String(chars);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(CharNormUtils.convert("\u4eca\u65e5/t \u80a1\u4ef7/n \u6307\u6570/n \uff1d/w (/w \u4eca\u65e5/t \u5e02\u4ef7/n \u603b\u503c/n //w \u57fa\u671f/n \u5e02\u4ef7/n \u603b\u503c/n )/w \u00d7/w 100/nx \u3002/w \u5e02\u4ef7/n \u603b\u503c/n \u4e3a/v \u5f53\u5929/t \u5168\u90e8/m \u80a1\u7968/n \u7684/u \u6536\u76d8\u4ef7/n \u4e58\u4ee5/v \u603b/b \u53d1\u884c/vn \u80a1\u6570/n \u3002/w \u8fd9\u6837/r ,/w \u4ee5/p \"/w \u57fa\u671f/n \"/w \u4e3a/v \u53c2\u7167\u7cfb/n ,/w \"/w \u4eca\u65e5/t \"/w \u80a1\u4ef7/n \u7684/u \u6da8\u6da8\u843d\u843d/vn \u4e5f/d \u5c31/d \u4e00\u76ee\u4e86\u7136/i \u4e86/y \u3002/w"));
    }

    static {
        AccessController.doPrivileged(() -> {
            try {
                List<String> lines = Resources.readLines(Resources.getResource(CharNormUtils.class, "char_norm"), Charsets.UTF_8);
                HashSet<String> left = Sets.newHashSet();
                ArrayList<String> right = Lists.newArrayList();
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    if (line.isEmpty() || !line.contains("=")) continue;
                    int x = line.indexOf("=");
                    if (x != 1 && line.length() != 3) {
                        System.err.println("Error " + line);
                        continue;
                    }
                    String first = line.substring(0, 1);
                    String second = line.substring(2, 3);
                    left.add(first);
                    right.add(second);
                    if (first.length() != 1 || second.length() != 1) continue;
                    CharNormUtils.table[first.charAt((int)0)] = second.charAt(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        });
    }
}

