/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.utils;

import com.mayabot.t.google.common.base.CharMatcher;

public class Characters {
    private static final int cha = 65248;
    public static final CharMatcher PUNCTUATION = new CharMatcher(){

        @Override
        public boolean matches(char c) {
            return Characters.isPunctuation(c);
        }

        @Override
        public String toString() {
            return "CharMatcher.PUNCTUATION";
        }
    };
    static final String hex = "0123456789ABCDEF";

    public static String fullWidth2halfWidth(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        int found = -1;
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch != '\u3000' && ('\uff00' > ch || ch > '\uff5e')) continue;
            found = i;
            break;
        }
        if (found > -1) {
            char[] charlist = input.toCharArray();
            int len2 = charlist.length;
            for (int i = found; i < len2; ++i) {
                char ch = charlist[i];
                if (ch == '\u3000') {
                    charlist[i] = 32;
                }
                if ('\uff00' >= ch || ch > '\uff5e') continue;
                charlist[i] = (char)(ch - 65248);
            }
            return new String(charlist);
        }
        return input;
    }

    public static void fullWidth2halfWidth(char[] charlist) {
        for (char ch : charlist) {
            if (ch == '\u3000') {
                charlist[i] = 32;
            }
            if ('\uff00' >= ch || ch > '\uff5e') continue;
            charlist[i] = (char)(ch - 65248);
        }
    }

    public static String halfWidth2fullWidth(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        int found = -1;
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch != ' ' && (' ' > ch || ch > '~')) continue;
            found = i;
            break;
        }
        if (found > -1) {
            char[] charlist = input.toCharArray();
            int len2 = charlist.length;
            for (int i = found; i < len2; ++i) {
                char ch = charlist[i];
                if (ch == ' ') {
                    charlist[i] = 12288;
                }
                if ('\"' >= ch || ch > '~') continue;
                charlist[i] = (char)(ch + 65248);
            }
            return new String(charlist);
        }
        return input;
    }

    public static boolean isPunctuation(char c) {
        if (c <= '\u007f') {
            if (c <= '/') {
                return true;
            }
            if (':' <= c && c <= '@') {
                return true;
            }
            if ('[' <= c && c <= '`') {
                return true;
            }
            if ('{' <= c && c <= '\u007f') {
                return true;
            }
            if (c == '\u00a0') {
                return true;
            }
        }
        if ('\u00a1' <= c && c <= '\u00bf') {
            return true;
        }
        if ('\uff00' <= c && c <= '\uffef') {
            if ('\ufe10' <= c && c <= '\ufe1f') {
                return true;
            }
            if ('\uff00' <= c && c <= '\uff0f') {
                return true;
            }
            if ('\uff1a' <= c && c <= '\uff20') {
                return true;
            }
            if ('\uff3b' <= c && c <= '\uff40') {
                return true;
            }
            if ('\uff5b' <= c && c <= '\uffef') {
                return true;
            }
        }
        if (c <= '\u303f') {
            if ('\u2010' <= c && c <= '\u2027') {
                return true;
            }
            if ('\u2030' <= c && c <= '\u205e') {
                return true;
            }
            if ('\u2e00' <= c && c <= '\u2e30') {
                return true;
            }
            return '\u3000' <= c && c <= '\u303f';
        }
        return false;
    }

    public static boolean isASCII(char c) {
        return c <= '\u007f';
    }

    public static String showCharacter(char c) {
        char[] tmp = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (int i = 0; i < 4; ++i) {
            tmp[5 - i] = hex.charAt(c & 0xF);
            c = (char)(c >> 4);
        }
        return String.copyValueOf(tmp);
    }

    public static int digit(char ch) {
        return Character.digit(ch, 10);
    }
}

