/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomCharSequence
implements CharSequence {
    private char[] text;
    private int offset;
    private int length;

    public CustomCharSequence(char[] text) {
        this(text, 0, text.length);
    }

    public CustomCharSequence(char[] text, int offset, int length) {
        this.text = text;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.text[this.offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CustomCharSequence(this.text, start + this.offset, end - start);
    }

    @Override
    public String toString() {
        return new String(this.text, this.offset, this.length);
    }

    public static void main(String[] args) {
        CustomCharSequence s = new CustomCharSequence("abcdefabg".toCharArray());
        System.out.println(s);
        Pattern p = Pattern.compile("ab");
        Matcher m = p.matcher(s);
        while (m.find()) {
            System.out.println(m.start() + " : " + m.group());
        }
    }
}

