/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.utils;

import com.mayabot.t.google.common.io.ByteStreams;
import com.mayabot.t.google.common.io.FileWriteMode;
import com.mayabot.t.google.common.io.Files;
import com.mayabot.t.google.common.io.Resources;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DownloadUtils {
    public static void main(String[] args) throws Exception {
        DownloadUtils.download("http://cdn.mayabot.com/nlp/hotel-test.txt.zip", new File("data/test.text.zip"));
        DownloadUtils.unzip(new File("data/test.text.zip"));
    }

    public static void download(String url, File file) throws IOException {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
        Resources.copy(new URL(url), outputStream);
        outputStream.flush();
        outputStream.close();
    }

    public static void unzip(File file) throws Exception {
        try (ZipInputStream zipInputStream = new ZipInputStream(Files.asByteSource(file).openBufferedStream());){
            ZipEntry entry = null;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String name = entry.getName();
                File toFile = new File(file.getParent(), name);
                OutputStream outputStream = Files.asByteSink(toFile, new FileWriteMode[0]).openBufferedStream();
                ByteStreams.copy(zipInputStream, outputStream);
                outputStream.flush();
                outputStream.close();
            }
        }
    }
}

