/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.t.google.common.collect;

import com.mayabot.t.google.common.annotations.GwtCompatible;
import com.mayabot.t.google.common.annotations.GwtIncompatible;
import com.mayabot.t.google.common.collect.ImmutableAsList;
import com.mayabot.t.google.common.collect.ImmutableCollection;
import com.mayabot.t.google.common.collect.ImmutableList;
import com.mayabot.t.google.common.collect.UnmodifiableListIterator;
import com.mayabot.t.google.j2objc.annotations.Weak;

@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    @Weak
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible(value="not present in emulated superclass")
    int copyIntoArray(Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }
}

