/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.t.google.inject.internal;

import com.mayabot.t.google.common.collect.Lists;
import com.mayabot.t.google.inject.Key;
import com.mayabot.t.google.inject.MembersInjector;
import com.mayabot.t.google.inject.Provider;
import com.mayabot.t.google.inject.TypeLiteral;
import com.mayabot.t.google.inject.internal.Errors;
import com.mayabot.t.google.inject.internal.InjectorImpl;
import com.mayabot.t.google.inject.internal.LookupProcessor;
import com.mayabot.t.google.inject.internal.Lookups;
import com.mayabot.t.google.inject.spi.Element;
import com.mayabot.t.google.inject.spi.MembersInjectorLookup;
import com.mayabot.t.google.inject.spi.ProviderLookup;
import java.util.List;

final class DeferredLookups
implements Lookups {
    private final InjectorImpl injector;
    private final List<Element> lookups = Lists.newArrayList();

    DeferredLookups(InjectorImpl injector) {
        this.injector = injector;
    }

    void initialize(Errors errors) {
        this.injector.lookups = this.injector;
        new LookupProcessor(errors).process(this.injector, this.lookups);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        ProviderLookup<T> lookup = new ProviderLookup<T>(key, key);
        this.lookups.add(lookup);
        return lookup.getProvider();
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type) {
        MembersInjectorLookup<T> lookup = new MembersInjectorLookup<T>(type, type);
        this.lookups.add(lookup);
        return lookup.getMembersInjector();
    }
}

