/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.t.google.inject.internal;

import com.mayabot.t.google.inject.Key;
import com.mayabot.t.google.inject.internal.BindingImpl;
import com.mayabot.t.google.inject.internal.CreationListener;
import com.mayabot.t.google.inject.internal.Errors;
import com.mayabot.t.google.inject.internal.ErrorsException;
import com.mayabot.t.google.inject.internal.InjectorImpl;
import com.mayabot.t.google.inject.internal.InternalContext;
import com.mayabot.t.google.inject.internal.InternalFactory;
import com.mayabot.t.google.inject.spi.Dependency;
import com.mayabot.t.google.inject.spi.PrivateElements;

final class ExposedKeyFactory<T>
implements InternalFactory<T>,
CreationListener {
    private final Key<T> key;
    private final PrivateElements privateElements;
    private BindingImpl<T> delegate;

    ExposedKeyFactory(Key<T> key, PrivateElements privateElements) {
        this.key = key;
        this.privateElements = privateElements;
    }

    @Override
    public void notify(Errors errors) {
        InjectorImpl privateInjector = (InjectorImpl)this.privateElements.getInjector();
        BindingImpl<T> explicitBinding = privateInjector.state.getExplicitBinding(this.key);
        if (explicitBinding.getInternalFactory() == this) {
            errors.withSource(explicitBinding.getSource()).exposedButNotBound(this.key);
            return;
        }
        this.delegate = explicitBinding;
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency, boolean linked) throws ErrorsException {
        return this.delegate.getInternalFactory().get(errors, context, dependency, linked);
    }
}

