/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.t.google.inject.internal;

import com.mayabot.t.google.common.collect.ImmutableList;
import com.mayabot.t.google.common.collect.Maps;
import com.mayabot.t.google.inject.Key;
import com.mayabot.t.google.inject.internal.ConstructionContext;
import com.mayabot.t.google.inject.internal.InjectorImpl;
import com.mayabot.t.google.inject.spi.Dependency;
import com.mayabot.t.google.inject.spi.DependencyAndSource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

final class InternalContext {
    private final InjectorImpl.InjectorOptions options;
    private Map<Object, ConstructionContext<?>> constructionContexts = Maps.newHashMap();
    private Dependency<?> dependency;
    private final DependencyStack state = new DependencyStack();

    InternalContext(InjectorImpl.InjectorOptions options) {
        this.options = options;
    }

    public InjectorImpl.InjectorOptions getInjectorOptions() {
        return this.options;
    }

    public <T> ConstructionContext<T> getConstructionContext(Object key) {
        ConstructionContext<Object> constructionContext = this.constructionContexts.get(key);
        if (constructionContext == null) {
            constructionContext = new ConstructionContext();
            this.constructionContexts.put(key, constructionContext);
        }
        return constructionContext;
    }

    public Dependency<?> getDependency() {
        return this.dependency;
    }

    public Dependency<?> pushDependency(Dependency<?> dependency, Object source) {
        Dependency<?> previous = this.dependency;
        this.dependency = dependency;
        this.state.add(dependency, source);
        return previous;
    }

    public void popStateAndSetDependency(Dependency<?> newDependency) {
        this.state.pop();
        this.dependency = newDependency;
    }

    public void pushState(Key<?> key, Object source) {
        this.state.add(key, source);
    }

    public void popState() {
        this.state.pop();
    }

    public List<DependencyAndSource> getDependencyChain() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.state.size(); i += 2) {
            Object evenEntry = this.state.get(i);
            Dependency dependency = evenEntry instanceof Key ? Dependency.get((Key)evenEntry) : (Dependency)evenEntry;
            builder.add(new DependencyAndSource(dependency, this.state.get(i + 1)));
        }
        return builder.build();
    }

    private static final class DependencyStack {
        private Object[] elements = new Object[16];
        private int size = 0;

        private DependencyStack() {
        }

        public void add(Object dependencyOrKey, Object source) {
            if (this.elements.length < this.size + 2) {
                this.elements = Arrays.copyOf(this.elements, this.elements.length * 3 / 2 + 2);
            }
            this.elements[this.size++] = dependencyOrKey;
            this.elements[this.size++] = source;
        }

        public void pop() {
            this.elements[--this.size] = null;
            this.elements[--this.size] = null;
        }

        public Object get(int i) {
            return this.elements[i];
        }

        public int size() {
            return this.size;
        }
    }
}

