/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.t.google.inject.internal;

import com.mayabot.t.google.common.base.Preconditions;
import com.mayabot.t.google.inject.Key;
import com.mayabot.t.google.inject.internal.BindingImpl;
import com.mayabot.t.google.inject.internal.ConstructionContext;
import com.mayabot.t.google.inject.internal.DelayedInitialize;
import com.mayabot.t.google.inject.internal.Errors;
import com.mayabot.t.google.inject.internal.ErrorsException;
import com.mayabot.t.google.inject.internal.InjectorImpl;
import com.mayabot.t.google.inject.internal.InternalContext;
import com.mayabot.t.google.inject.internal.ProviderInternalFactory;
import com.mayabot.t.google.inject.internal.ProvisionListenerStackCallback;
import com.mayabot.t.google.inject.spi.Dependency;
import javax.inject.Provider;

class ProvidedByInternalFactory<T>
extends ProviderInternalFactory<T>
implements DelayedInitialize {
    private final Class<?> rawType;
    private final Class<? extends Provider<?>> providerType;
    private final Key<? extends Provider<T>> providerKey;
    private BindingImpl<? extends Provider<T>> providerBinding;
    private ProvisionListenerStackCallback<T> provisionCallback;

    ProvidedByInternalFactory(Class<?> rawType, Class<? extends Provider<?>> providerType, Key<? extends Provider<T>> providerKey) {
        super(providerKey);
        this.rawType = rawType;
        this.providerType = providerType;
        this.providerKey = providerKey;
    }

    void setProvisionListenerCallback(ProvisionListenerStackCallback<T> listener) {
        this.provisionCallback = listener;
    }

    @Override
    public void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
        this.providerBinding = injector.getBindingOrThrow(this.providerKey, errors, InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Errors errors, InternalContext context, Dependency dependency, boolean linked) throws ErrorsException {
        Preconditions.checkState(this.providerBinding != null, "not initialized");
        context.pushState(this.providerKey, this.providerBinding.getSource());
        try {
            errors = errors.withSource(this.providerKey);
            Provider<T> provider = this.providerBinding.getInternalFactory().get(errors, context, dependency, true);
            T t = this.circularGet(provider, errors, context, dependency, this.provisionCallback);
            return t;
        }
        finally {
            context.popState();
        }
    }

    @Override
    protected T provision(Provider<? extends T> provider, Errors errors, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws ErrorsException {
        try {
            T o = super.provision(provider, errors, dependency, constructionContext);
            if (o != null && !this.rawType.isInstance(o)) {
                throw errors.subtypeNotProvided(this.providerType, this.rawType).toException();
            }
            T t = o;
            return t;
        }
        catch (RuntimeException e) {
            throw errors.errorInProvider(e).toException();
        }
    }
}

