/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.t.google.inject.util;

import com.mayabot.t.google.common.base.Objects;
import com.mayabot.t.google.common.base.Preconditions;
import com.mayabot.t.google.common.collect.ImmutableSet;
import com.mayabot.t.google.common.collect.Sets;
import com.mayabot.t.google.inject.Inject;
import com.mayabot.t.google.inject.Injector;
import com.mayabot.t.google.inject.Provider;
import com.mayabot.t.google.inject.spi.Dependency;
import com.mayabot.t.google.inject.spi.InjectionPoint;
import com.mayabot.t.google.inject.spi.ProviderWithDependencies;
import java.util.HashSet;
import java.util.Set;

public final class Providers {
    private Providers() {
    }

    public static <T> Provider<T> of(T instance) {
        return new ConstantProvider(instance);
    }

    public static <T> Provider<T> guicify(javax.inject.Provider<T> provider) {
        if (provider instanceof Provider) {
            return (Provider)provider;
        }
        javax.inject.Provider<T> delegate = Preconditions.checkNotNull(provider, "provider");
        Set<InjectionPoint> injectionPoints = InjectionPoint.forInstanceMethodsAndFields(provider.getClass());
        if (injectionPoints.isEmpty()) {
            return new GuicifiedProvider(delegate);
        }
        HashSet<Dependency<?>> mutableDeps = Sets.newHashSet();
        for (InjectionPoint ip : injectionPoints) {
            mutableDeps.addAll(ip.getDependencies());
        }
        ImmutableSet dependencies = ImmutableSet.copyOf(mutableDeps);
        return new GuicifiedProviderWithDependencies(dependencies, delegate);
    }

    private static final class GuicifiedProviderWithDependencies<T>
    extends GuicifiedProvider<T>
    implements ProviderWithDependencies<T> {
        private final Set<Dependency<?>> dependencies;

        private GuicifiedProviderWithDependencies(Set<Dependency<?>> dependencies, javax.inject.Provider<T> delegate) {
            super(delegate);
            this.dependencies = dependencies;
        }

        @Inject
        void initialize(Injector injector) {
            injector.injectMembers(this.delegate);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }
    }

    private static class GuicifiedProvider<T>
    implements Provider<T> {
        protected final javax.inject.Provider<T> delegate;

        private GuicifiedProvider(javax.inject.Provider<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T get() {
            return this.delegate.get();
        }

        public String toString() {
            return "guicified(" + this.delegate + ")";
        }

        public boolean equals(Object obj) {
            return obj instanceof GuicifiedProvider && Objects.equal(this.delegate, ((GuicifiedProvider)obj).delegate);
        }

        public int hashCode() {
            return Objects.hashCode(this.delegate);
        }
    }

    private static final class ConstantProvider<T>
    implements Provider<T> {
        private final T instance;

        private ConstantProvider(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public String toString() {
            return "of(" + this.instance + ")";
        }

        public boolean equals(Object obj) {
            return obj instanceof ConstantProvider && Objects.equal(this.instance, ((ConstantProvider)obj).instance);
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }
    }
}

