/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.perceptron;

import com.mayabot.nlp.perceptron.EvaluateResult;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.TrainSample;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\"\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a8\u0006\f"}, d2={"simpleEvaluate", "Lcom/mayabot/nlp/perceptron/EvaluateResult;", "model", "Lcom/mayabot/nlp/perceptron/Perceptron;", "samples", "", "Lcom/mayabot/nlp/perceptron/TrainSample;", "wordCorrect", "", "gold", "", "pred", "mynlp-perceptron"})
public final class EvaluateUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final EvaluateResult simpleEvaluate(@NotNull Perceptron model, @NotNull List<TrainSample> samples) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(samples, (String)"samples");
        int total = 0;
        int right = 0;
        Iterable $this$forEach$iv = samples;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrainSample sample = (TrainSample)element$iv;
            boolean bl = false;
            total += sample.getLabel().length;
            int[] gold = sample.getLabel();
            int[] pred = model.decode(sample.getFeatureSequence());
            int n = 0;
            int n2 = sample.getLabel().length;
            while (n < n2) {
                void i;
                if (gold[i] == pred[i]) {
                    int n3 = right;
                    right = n3 + 1;
                }
                ++i;
            }
        }
        return new EvaluateResult(total, total, right);
    }

    public static final int wordCorrect(@NotNull List<String> gold, @NotNull List<String> pred) {
        Intrinsics.checkParameterIsNotNull(gold, (String)"gold");
        Intrinsics.checkParameterIsNotNull(pred, (String)"pred");
        int goldIndex = 0;
        int predIndex = 0;
        int goldLen = 0;
        int predLen = 0;
        int correct = 0;
        while (goldIndex < gold.size() && predIndex < pred.size()) {
            if (goldLen == predLen) {
                if (Intrinsics.areEqual((Object)gold.get(goldIndex), (Object)pred.get(predIndex))) {
                    ++correct;
                    goldLen += gold.get(goldIndex).length();
                    predLen += gold.get(goldIndex).length();
                    ++goldIndex;
                    ++predIndex;
                    continue;
                }
                goldLen += gold.get(goldIndex).length();
                predLen += pred.get(predIndex).length();
                ++goldIndex;
                ++predIndex;
                continue;
            }
            if (goldLen < predLen) {
                goldLen += gold.get(goldIndex).length();
                ++goldIndex;
                continue;
            }
            predLen += pred.get(predIndex).length();
            ++predIndex;
        }
        return correct;
    }
}

