/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.pinyin;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mayabot.nlp.pinyin.model.Pinyin;
import com.mayabot.nlp.utils.Characters;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PinyinResult {
    private List<Pinyin> pinyinList;
    private String text;
    private boolean skipNull = false;
    private boolean ignorePunctuation = true;
    private boolean fuzzy;
    private static Pattern pattern = Pattern.compile("(^zh|^ch|^sh|iang$|ang$|ing$|eng$|uang$)");
    private static ImmutableMap<String, String> fuzzyMap = ImmutableMap.builder().put((Object)"zh", (Object)"z").put((Object)"ch", (Object)"c").put((Object)"sh", (Object)"s").put((Object)"eng", (Object)"en").put((Object)"ang", (Object)"an").put((Object)"ing", (Object)"in").put((Object)"iang", (Object)"ian").put((Object)"uang", (Object)"uan").build();

    PinyinResult(List<Pinyin> pinyinList, String text) {
        this.pinyinList = pinyinList;
        this.text = text;
    }

    public PinyinResult fuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
        return this;
    }

    public PinyinResult skipNull(boolean skipNull) {
        this.skipNull = skipNull;
        return this;
    }

    public PinyinResult ignorePunctuation(boolean ignore) {
        this.ignorePunctuation = this.ignorePunctuation;
        return this;
    }

    public String asString() {
        return this.asString(" ");
    }

    public static void main(String[] args) {
    }

    public List<String> asList() {
        ArrayList list = Lists.newArrayListWithCapacity((int)this.pinyinList.size());
        int i = 0;
        for (Pinyin pinyin : this.pinyinList) {
            if (pinyin == Pinyin.none5 && !this.skipNull) {
                char x = this.text.charAt(i);
                if (!this.ignorePunctuation || !Characters.isPunctuation((char)x)) {
                    list.add(this.text.charAt(i) + "");
                }
            } else {
                String withoutTone = pinyin.getPinyinWithoutTone();
                if (this.fuzzy) {
                    Matcher matcher = pattern.matcher(withoutTone);
                    StringBuffer sb = new StringBuffer();
                    if (matcher.find()) {
                        String part = matcher.group();
                        matcher.appendReplacement(sb, (String)fuzzyMap.get((Object)part));
                    }
                }
                list.add(withoutTone);
            }
            ++i;
        }
        return list;
    }

    public List<Character> asHeadList() {
        ArrayList list = Lists.newArrayListWithCapacity((int)this.pinyinList.size());
        int i = 0;
        for (Pinyin pinyin : this.pinyinList) {
            if (pinyin == Pinyin.none5 && !this.skipNull) {
                char x = this.text.charAt(i);
                if (!this.ignorePunctuation || !Characters.isPunctuation((char)x)) {
                    list.add(Character.valueOf(this.text.charAt(i)));
                }
            } else {
                list.add(Character.valueOf(pinyin.getFirstChar()));
            }
            ++i;
        }
        return list;
    }

    public String asString(String splitter) {
        return Joiner.on((String)splitter).join(this.asList());
    }

    public String asHeadString(String splitter) {
        return Joiner.on((String)splitter).join(this.asHeadList());
    }

    public String asHeadString() {
        return Joiner.on((String)" ").join(this.asHeadList());
    }

    public String toString() {
        return this.asString();
    }
}

