/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.pinyin;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.SettingItem;
import com.mayabot.nlp.pinyin.BasePinyinDictionary;
import com.mayabot.nlp.pinyin.model.Pinyin;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.utils.CharSourceLineReader;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.inject.Singleton;

@Singleton
public class PinyinDictionary
extends BasePinyinDictionary {
    public static final String version = "1.0.0";
    public static final SettingItem<String> pinyinSetting = SettingItem.string((String)"pinyin.dict", (String)"mynlp-pinyin.txt");
    public static final SettingItem<String> pinyinExtDicSetting = SettingItem.string((String)"pinyin.ext.dict", null);
    private final MynlpEnv mynlp;

    @Inject
    public PinyinDictionary(MynlpEnv mynlp) {
        this.mynlp = mynlp;
        String rsName = (String)mynlp.getSettings().get(pinyinSetting);
        mynlp.registeResourceMissing("pinyin", rsName, "mynlp-resource-pinyin.jar", version);
        this.rebuild();
    }

    @Override
    TreeMap<String, Pinyin[]> load() {
        ArrayList list = Lists.newArrayList();
        list.add(this.mynlp.loadResource(pinyinSetting));
        NlpResource ext = this.mynlp.loadResource(pinyinExtDicSetting);
        if (ext != null) {
            list.add(ext);
        }
        TreeMap<String, Pinyin[]> map = new TreeMap<String, Pinyin[]>();
        for (NlpResource dictResource : list) {
            try {
                CharSourceLineReader reader = dictResource.openLineReader();
                Throwable throwable = null;
                try {
                    while (reader.hasNext()) {
                        String line = (String)reader.next();
                        String[] param = line.split("=");
                        String key = param[0];
                        Pinyin[] pinyins = this.parse(param[1]);
                        if (pinyins == null) continue;
                        map.put(key, pinyins);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
            }
        }
        return map;
    }
}

