/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.pinyin;

import com.mayabot.nlp.common.Lists;
import com.mayabot.nlp.pinyin.model.Pinyin;
import com.mayabot.nlp.utils.Characters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PinyinResult {
    private List<Pinyin> pinyinList;
    private String text;
    private boolean keepPunctuation = false;
    private boolean keepNum = true;
    private boolean keepAlpha = true;
    private boolean keepOthers = false;
    private boolean fuzzy;
    private static Pattern pattern = Pattern.compile("(^zh|^ch|^sh|iang$|ang$|ing$|eng$|uang$)");
    private static Map<String, String> fuzzyMap = PinyinResult.fmap();

    PinyinResult(List<Pinyin> pinyinList, String text) {
        this.pinyinList = pinyinList;
        this.text = text;
    }

    public PinyinResult fuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
        return this;
    }

    public PinyinResult keepPunctuation(boolean keep) {
        this.keepPunctuation = keep;
        return this;
    }

    public PinyinResult keepNum(boolean keep) {
        this.keepNum = keep;
        return this;
    }

    public PinyinResult keepAlpha(boolean keep) {
        this.keepAlpha = keep;
        return this;
    }

    public PinyinResult keepOthers(boolean keep) {
        this.keepOthers = keep;
        return this;
    }

    public String asString() {
        return this.asString(" ");
    }

    private static Map<String, String> fmap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("zh", "z");
        map.put("ch", "c");
        map.put("sh", "s");
        map.put("eng", "en");
        map.put("ang", "an");
        map.put("ing", "in");
        map.put("iang", "ian");
        map.put("uang", "uan");
        return map;
    }

    public static void main(String[] args) {
    }

    public List<String> asList() {
        ArrayList list = Lists.newArrayListWithCapacity((int)this.pinyinList.size());
        int i = 0;
        for (Pinyin pinyin : this.pinyinList) {
            if (pinyin == Pinyin.none5) {
                char x = this.text.charAt(i);
                String target = null;
                if (this.keepPunctuation && Characters.isPunctuation((char)x)) {
                    target = "" + x;
                } else if (this.keepNum && x >= '0' && x <= '9') {
                    target = "" + x;
                } else if (this.keepAlpha && (x >= 'a' && x <= 'z' || x >= 'A' && x <= 'Z')) {
                    target = "" + x;
                } else if (this.keepOthers) {
                    target = "" + x;
                }
                list.add(target);
            } else {
                String withoutTone = pinyin.getPinyinWithoutTone();
                if (this.fuzzy) {
                    Matcher matcher = pattern.matcher(withoutTone);
                    StringBuffer sb = new StringBuffer();
                    if (matcher.find()) {
                        String part = matcher.group();
                        matcher.appendReplacement(sb, fuzzyMap.get(part));
                    }
                    matcher.appendTail(sb);
                    list.add(sb.toString());
                } else {
                    list.add(withoutTone);
                }
            }
            ++i;
        }
        return list;
    }

    public List<Character> asHeadList() {
        ArrayList list = Lists.newArrayListWithCapacity((int)this.pinyinList.size());
        int i = 0;
        for (Pinyin pinyin : this.pinyinList) {
            if (pinyin == Pinyin.none5) {
                char x = this.text.charAt(i);
                boolean out = false;
                if (this.keepPunctuation && Characters.isPunctuation((char)x)) {
                    out = true;
                } else if (this.keepNum && x >= '0' && x <= '9') {
                    out = true;
                } else if (this.keepAlpha && (x >= 'a' && x <= 'z' || x >= 'A' && x <= 'Z')) {
                    out = true;
                } else if (this.keepOthers) {
                    out = true;
                }
                if (out) {
                    list.add(Character.valueOf(x));
                } else {
                    list.add(null);
                }
            } else {
                list.add(Character.valueOf(pinyin.getFirstChar()));
            }
            ++i;
        }
        return list;
    }

    public String asString(String splitter) {
        return this.joinSkipNull(this.asList(), splitter);
    }

    public String asHeadString(String splitter) {
        return this.joinSkipNull(this.asHeadList(), splitter);
    }

    private String joinSkipNull(List list, String splitter) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object x : list) {
            if (x == null) continue;
            if (first) {
                first = false;
            } else if (splitter != "") {
                sb.append(splitter);
            }
            sb.append(x);
        }
        return sb.toString();
    }

    public String asHeadString() {
        return this.asHeadString(" ");
    }

    public String toString() {
        return this.asString();
    }
}

