/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.pinyin.split;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.perceptron.EvaluateFunction;
import com.mayabot.nlp.perceptron.EvaluateResult;
import com.mayabot.nlp.perceptron.EvaluateUtilsKt;
import com.mayabot.nlp.perceptron.PerceptronDefinition;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.pinyin.split.PinyinSplitApp;
import com.mayabot.nlp.pinyin.split.PinyinSplitDefinition;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J6\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\u0016\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00190\u001c0\u00162\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016\u00a8\u0006 "}, d2={"Lcom/mayabot/nlp/pinyin/split/PinyinSplitDefinition;", "Lcom/mayabot/nlp/perceptron/PerceptronDefinition;", "", "", "()V", "evaluateFunction", "Lcom/mayabot/nlp/perceptron/EvaluateFunction;", "model", "Lcom/mayabot/nlp/perceptron/PerceptronModel;", "featureFunction", "", "sentence", "size", "", "position", "buffer", "Lcom/mayabot/nlp/common/FastStringBuilder;", "emit", "Lkotlin/Function0;", "featureMaxSize", "inputList2InputSeq", "list", "", "labels", "", "", "()[Ljava/lang/String;", "parseAnnotateText", "Lkotlin/Pair;", "text", "preProcessInputSequence", "input", "mynlp-pinyin"})
public final class PinyinSplitDefinition
implements PerceptronDefinition<Character, char[]> {
    @NotNull
    public String[] labels() {
        return new String[]{"B", "M", "E", "S"};
    }

    public int featureMaxSize() {
        return 4;
    }

    public void featureFunction(@NotNull char[] sentence, int size, int position, @NotNull FastStringBuilder buffer, @NotNull Function0<Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        char CHAR_NULL = '\u0000';
        int lastIndex = size - position - 1;
        char pre2Char = position > 1 ? sentence[position - 2] : CHAR_NULL;
        char preChar = position > 0 ? sentence[position - 1] : CHAR_NULL;
        char curChar = sentence[position];
        char nextChar = lastIndex > 0 ? sentence[position + 1] : CHAR_NULL;
        char next2Char = lastIndex > 1 ? sentence[position + 2] : CHAR_NULL;
        buffer.clear();
        buffer.set2(curChar, '2');
        emit.invoke();
        if (position > 0) {
            buffer.clear();
            buffer.set2(preChar, '1');
            emit.invoke();
            buffer.clear();
            buffer.set4(preChar, '/', curChar, '5');
            emit.invoke();
            if (position > 1) {
                buffer.clear();
                buffer.set4(pre2Char, '/', preChar, '4');
                emit.invoke();
            }
        }
        if (lastIndex > 0) {
            buffer.clear();
            buffer.set2(nextChar, '3');
            emit.invoke();
            buffer.clear();
            buffer.set4(curChar, '/', nextChar, '6');
            emit.invoke();
            if (lastIndex > 1) {
                buffer.clear();
                buffer.set4(nextChar, '/', next2Char, '7');
                emit.invoke();
            }
        }
    }

    @NotNull
    public char[] inputList2InputSeq(@NotNull List<Character> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        return CollectionsKt.toCharArray((Collection)list);
    }

    @NotNull
    public List<Pair<Character, String>> parseAnnotateText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)StringsKt.splitToSequence$default((CharSequence)text, (char[])new char[]{'\ufe4d'}, (boolean)false, (int)0, (int)6, null), (Function1)parseAnnotateText.1.INSTANCE));
    }

    @Nullable
    public EvaluateFunction evaluateFunction(@NotNull PerceptronModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        return new EvaluateFunction(model){
            final /* synthetic */ PerceptronModel $model;

            @NotNull
            public final EvaluateResult evaluate(List<String> sampleList) {
                int count = 0;
                int goldTotal = 0;
                int predTotal = 0;
                int correct = 0;
                PinyinSplitApp segmenter = new PinyinSplitApp(this.$model);
                Iterator<String> iterator = sampleList.iterator();
                while (iterator.hasNext()) {
                    String line;
                    String string = line = iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"line");
                    List wordArray = StringsKt.split$default((CharSequence)string, (String[])new String[]{"\ufe4d"}, (boolean)false, (int)0, (int)6, null);
                    goldTotal += wordArray.size();
                    String text = CollectionsKt.joinToString$default((Iterable)wordArray, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                    List predArray = PinyinSplitApp.decodeToWordList$default(segmenter, text, false, 2, null);
                    predTotal += predArray.size();
                    correct += EvaluateUtilsKt.wordCorrect((List)wordArray, (List)predArray);
                    ++count;
                }
                return new EvaluateResult(goldTotal, predTotal, correct);
            }
            {
                this.$model = perceptronModel;
            }
        };
    }

    @NotNull
    public char[] preProcessInputSequence(@NotNull char[] input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return input;
    }
}

