/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.jpa.parsing;

import java.util.Locale;

public enum PersistenceXml {
    TAG_PERSISTENCE("persistence"),
    TAG_PERSISTENCE_UNIT("persistence-unit"),
    TAG_PROPERTIES("properties"),
    TAG_PROPERTY("property"),
    TAG_NON_JTA_DATA_SOURCE("non-jta-data-source"),
    TAG_JTA_DATA_SOURCE("jta-data-source"),
    TAG_CLASS("class"),
    TAG_MAPPING_FILE("mapping-file"),
    TAG_JAR_FILE("jar-file"),
    TAG_EXCLUDE_UNLISTED_CLASSES("exclude-unlisted-classes"),
    TAG_VALIDATION_MODE("validation-mode"),
    TAG_SHARED_CACHE_MODE("shared-cache-mode"),
    TAG_PROVIDER("provider"),
    TAG_UNKNOWN$("unknown$"),
    ATTR_UNIT_NAME("name"),
    ATTR_TRANSACTION_TYPE("transaction-type"),
    ATTR_SCHEMA_VERSION("version");

    private final String name;

    private PersistenceXml(String name) {
        this.name = name;
    }

    public boolean equals(String aName) {
        return this.name.equalsIgnoreCase(aName);
    }

    public static PersistenceXml parse(String aName) {
        try {
            return PersistenceXml.valueOf("TAG_" + aName.replace('-', '_').toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return TAG_UNKNOWN$;
        }
    }

    public String toString() {
        return this.name;
    }
}

