/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.jpa.parsing;

import com.orientechnologies.orient.object.jpa.parsing.JPAHandler;
import com.orientechnologies.orient.object.jpa.parsing.JPAVersion;
import com.orientechnologies.orient.object.jpa.parsing.PersistenceXml;
import com.orientechnologies.orient.object.jpa.parsing.SchemaLocatingHandler;
import com.orientechnologies.orient.object.jpa.parsing.StopSAXParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PersistenceXmlUtil {
    public static final String PERSISTENCE_NS_URI = "http://java.sun.com/xml/ns/persistence";
    private static final SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    public static final String PERSISTENCE_XML_ROOT = "META-INF/";
    public static final String PERSISTENCE_XML_BASE_NAME = "persistence.xml";
    public static final String PERSISTENCE_XSD_DIR = "META-INF/persistence/";
    public static final String PERSISTENCE_XML = "META-INF/persistence.xml";

    private PersistenceXmlUtil() {
    }

    public static PersistenceUnitInfo findPersistenceUnit(String unitName, Collection<? extends PersistenceUnitInfo> units) {
        if (units == null || unitName == null) {
            return null;
        }
        for (PersistenceUnitInfo persistenceUnitInfo : units) {
            if (!unitName.equals(persistenceUnitInfo.getPersistenceUnitName())) continue;
            return persistenceUnitInfo;
        }
        return null;
    }

    public static Collection<? extends PersistenceUnitInfo> parse(URL persistenceXml) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(persistenceXml.openStream());
            JPAVersion jpaVersion = PersistenceXmlUtil.getSchemaVersion(is);
            Schema schema = PersistenceXmlUtil.getSchema(jpaVersion);
            if (schema == null) {
                throw new PersistenceException("Schema is unknown");
            }
            is = new BufferedInputStream(persistenceXml.openStream());
            parserFactory.setNamespaceAware(true);
            int endIndex = persistenceXml.getPath().length() - PERSISTENCE_XML_BASE_NAME.length();
            URL persistenceXmlRoot = new URL("file://" + persistenceXml.getFile().substring(0, endIndex));
            Collection<? extends PersistenceUnitInfo> collection = PersistenceXmlUtil.getPersistenceUnits(is, persistenceXmlRoot, jpaVersion);
            return collection;
        }
        catch (Exception e) {
            throw new PersistenceException("Something goes wrong while parsing persistence.xml", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Schema getSchema(JPAVersion version) throws SAXException {
        String schemaPath = PERSISTENCE_XSD_DIR + version.getFilename();
        InputStream inputStream = PersistenceXmlUtil.class.getClassLoader().getResourceAsStream(schemaPath);
        return schemaFactory.newSchema(new StreamSource(inputStream));
    }

    public static JPAVersion getSchemaVersion(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        SchemaLocatingHandler schemaHandler = PersistenceXmlUtil.parse(is, new SchemaLocatingHandler());
        return JPAVersion.parse(schemaHandler.getVersion());
    }

    public static Collection<? extends PersistenceUnitInfo> getPersistenceUnits(InputStream is, URL xmlRoot, JPAVersion version) throws ParserConfigurationException, SAXException, IOException {
        JPAHandler handler = new JPAHandler(xmlRoot, version);
        return PersistenceXmlUtil.parse(is, handler).getPersistenceUnits();
    }

    protected static <T extends DefaultHandler> T parse(InputStream is, T handler) throws ParserConfigurationException, SAXException, IOException {
        try {
            SAXParser parser = parserFactory.newSAXParser();
            parser.parse(is, handler);
        }
        catch (StopSAXParser stopSAXParser) {
            // empty catch block
        }
        return handler;
    }

    public static String parseSchemaVersion(String uri, PersistenceXml element, Attributes attributes) throws SAXException {
        if (PERSISTENCE_NS_URI.equals(uri) && PersistenceXml.TAG_PERSISTENCE == element) {
            return attributes.getValue(PersistenceXml.ATTR_SCHEMA_VERSION.toString());
        }
        return null;
    }

    static {
        parserFactory.setNamespaceAware(true);
    }
}

