/*
 * Decompiled with CFR 0.152.
 */
package com.wuwenze.poi.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;

public class RegexUtil {
    private static final LoadingCache<String, Pattern> mRegexPatternLoadingCache = CacheBuilder.newBuilder().maximumSize(5L).build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String pattern) {
            return Pattern.compile(pattern);
        }
    });

    public static Boolean isMatches(String pattern, Object value) {
        try {
            String valueString = (String)value;
            return ((Pattern)mRegexPatternLoadingCache.get((Object)pattern)).matcher(valueString).matches();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return false;
        }
    }

    private RegexUtil() {
    }
}

