/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.transcode;

import com.ximpleware.TranscodeException;
import java.io.IOException;
import java.io.OutputStream;

public class UTF16BE_Coder {
    public static int encode(byte[] output, int offset, int ch) {
        if (ch < 65536) {
            output[offset + 1] = (byte)(ch & 0xFF);
            output[offset] = (byte)((ch & 0xFF00) >> 8);
            return 2 + offset;
        }
        int tmp = ch - 65536;
        int w1 = 0xD800 | tmp & 0xFFC00;
        int w2 = 0xDC00 | tmp & 0x3FF;
        output[offset] = (byte)((w1 & 0xFF00) >> 8);
        output[offset + 1] = (byte)(w1 & 0xFF);
        output[offset + 2] = (byte)((w2 & 0xFF00) >> 8);
        output[offset + 3] = (byte)(w2 & 0xFF);
        return 4 + offset;
    }

    public static long decode(byte[] input, int offset) {
        int temp = input[offset] << 8 | input[offset + 1];
        if (temp < 55296 || temp > 57343) {
            long l = offset + 2;
            return l << 32 | (long)temp;
        }
        int val = temp;
        temp = input[offset + 2] << 8 | input[offset + 3];
        val = (temp - 55296 << 10) + (val - 56320) + 65536;
        long l = offset + 4;
        return l << 32 | (long)temp;
    }

    public static int getLen(int ch) {
        if (ch < 65536) {
            return 2;
        }
        return 4;
    }

    public static final void encodeAndWrite(OutputStream os, int ch) throws IOException, TranscodeException {
        if (ch < 65536) {
            os.write((ch & 0xFF00) >> 8);
            os.write(ch);
        } else {
            int tmp = ch - 65536;
            int w1 = 0xD800 | tmp & 0xFFC00;
            int w2 = 0xDC00 | tmp & 0x3FF;
            os.write((byte)((w1 & 0xFF00) >> 8));
            os.write((byte)(w1 & 0xFF));
            os.write((byte)((w2 & 0xFF00) >> 8));
            os.write((byte)(w2 & 0xFF));
        }
    }
}

