/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.executor;

import com.xxl.job.core.biz.AdminBiz;
import com.xxl.job.core.biz.ExecutorBiz;
import com.xxl.job.core.biz.impl.ExecutorBizImpl;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.thread.ExecutorRegistryThread;
import com.xxl.job.core.thread.JobLogFileCleanThread;
import com.xxl.job.core.thread.JobThread;
import com.xxl.job.core.thread.TriggerCallbackThread;
import com.xxl.rpc.registry.ServiceRegistry;
import com.xxl.rpc.remoting.invoker.XxlRpcInvokerFactory;
import com.xxl.rpc.remoting.invoker.call.CallType;
import com.xxl.rpc.remoting.invoker.reference.XxlRpcReferenceBean;
import com.xxl.rpc.remoting.invoker.route.LoadBalance;
import com.xxl.rpc.remoting.net.NetEnum;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.IpUtil;
import com.xxl.rpc.util.NetUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlJobExecutor {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobExecutor.class);
    private String adminAddresses;
    private String appName;
    private String ip;
    private int port;
    private String accessToken;
    private String logPath;
    private int logRetentionDays;
    private static List<AdminBiz> adminBizList;
    private static Serializer serializer;
    private XxlRpcProviderFactory xxlRpcProviderFactory = null;
    private static ConcurrentMap<String, IJobHandler> jobHandlerRepository;
    private static ConcurrentMap<Integer, JobThread> jobThreadRepository;

    public void setAdminAddresses(String adminAddresses) {
        this.adminAddresses = adminAddresses;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public void setLogRetentionDays(int logRetentionDays) {
        this.logRetentionDays = logRetentionDays;
    }

    public void start() throws Exception {
        XxlJobFileAppender.initLogPath(this.logPath);
        this.initAdminBizList(this.adminAddresses, this.accessToken);
        JobLogFileCleanThread.getInstance().start(this.logRetentionDays);
        TriggerCallbackThread.getInstance().start();
        this.port = this.port > 0 ? this.port : NetUtil.findAvailablePort((int)9999);
        this.ip = this.ip != null && this.ip.trim().length() > 0 ? this.ip : IpUtil.getIp();
        this.initRpcProvider(this.ip, this.port, this.appName, this.accessToken);
    }

    public void destroy() {
        if (jobThreadRepository.size() > 0) {
            for (Map.Entry item : jobThreadRepository.entrySet()) {
                XxlJobExecutor.removeJobThread((Integer)item.getKey(), "web container destroy and kill the job.");
            }
            jobThreadRepository.clear();
        }
        jobHandlerRepository.clear();
        JobLogFileCleanThread.getInstance().toStop();
        TriggerCallbackThread.getInstance().toStop();
        this.stopRpcProvider();
        this.stopInvokerFactory();
    }

    private void initAdminBizList(String adminAddresses, String accessToken) throws Exception {
        serializer = Serializer.SerializeEnum.HESSIAN.getSerializer();
        if (adminAddresses != null && adminAddresses.trim().length() > 0) {
            for (String address : adminAddresses.trim().split(",")) {
                if (address == null || address.trim().length() <= 0) continue;
                String addressUrl = address.concat("/api");
                AdminBiz adminBiz = (AdminBiz)new XxlRpcReferenceBean(NetEnum.NETTY_HTTP, serializer, CallType.SYNC, LoadBalance.ROUND, AdminBiz.class, null, 3000L, addressUrl, accessToken, null, null).getObject();
                if (adminBizList == null) {
                    adminBizList = new ArrayList<AdminBiz>();
                }
                adminBizList.add(adminBiz);
            }
        }
    }

    private void stopInvokerFactory() {
        try {
            XxlRpcInvokerFactory.getInstance().stop();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static List<AdminBiz> getAdminBizList() {
        return adminBizList;
    }

    public static Serializer getSerializer() {
        return serializer;
    }

    private void initRpcProvider(String ip, int port, String appName, String accessToken) throws Exception {
        String address = IpUtil.getIpPort((String)ip, (int)port);
        HashMap<String, String> serviceRegistryParam = new HashMap<String, String>();
        serviceRegistryParam.put("appName", appName);
        serviceRegistryParam.put("address", address);
        this.xxlRpcProviderFactory = new XxlRpcProviderFactory();
        this.xxlRpcProviderFactory.initConfig(NetEnum.NETTY_HTTP, Serializer.SerializeEnum.HESSIAN.getSerializer(), ip, port, accessToken, ExecutorServiceRegistry.class, serviceRegistryParam);
        this.xxlRpcProviderFactory.addService(ExecutorBiz.class.getName(), null, (Object)new ExecutorBizImpl());
        this.xxlRpcProviderFactory.start();
    }

    private void stopRpcProvider() {
        try {
            this.xxlRpcProviderFactory.stop();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static IJobHandler registJobHandler(String name, IJobHandler jobHandler) {
        logger.info(">>>>>>>>>>> xxl-job register jobhandler success, name:{}, jobHandler:{}", (Object)name, (Object)jobHandler);
        return jobHandlerRepository.put(name, jobHandler);
    }

    public static IJobHandler loadJobHandler(String name) {
        return (IJobHandler)jobHandlerRepository.get(name);
    }

    public static JobThread registJobThread(int jobId, IJobHandler handler, String removeOldReason) {
        JobThread newJobThread = new JobThread(jobId, handler);
        newJobThread.start();
        logger.info(">>>>>>>>>>> xxl-job regist JobThread success, jobId:{}, handler:{}", new Object[]{jobId, handler});
        JobThread oldJobThread = jobThreadRepository.put(jobId, newJobThread);
        if (oldJobThread != null) {
            oldJobThread.toStop(removeOldReason);
            oldJobThread.interrupt();
        }
        return newJobThread;
    }

    public static void removeJobThread(int jobId, String removeOldReason) {
        JobThread oldJobThread = (JobThread)jobThreadRepository.remove(jobId);
        if (oldJobThread != null) {
            oldJobThread.toStop(removeOldReason);
            oldJobThread.interrupt();
        }
    }

    public static JobThread loadJobThread(int jobId) {
        JobThread jobThread = (JobThread)jobThreadRepository.get(jobId);
        return jobThread;
    }

    static {
        jobHandlerRepository = new ConcurrentHashMap<String, IJobHandler>();
        jobThreadRepository = new ConcurrentHashMap<Integer, JobThread>();
    }

    public static class ExecutorServiceRegistry
    extends ServiceRegistry {
        public void start(Map<String, String> param) {
            ExecutorRegistryThread.getInstance().start(param.get("appName"), param.get("address"));
        }

        public void stop() {
            ExecutorRegistryThread.getInstance().toStop();
        }

        public boolean registry(Set<String> keys, String value) {
            return false;
        }

        public boolean remove(Set<String> keys, String value) {
            return false;
        }

        public Map<String, TreeSet<String>> discovery(Set<String> keys) {
            return null;
        }

        public TreeSet<String> discovery(String key) {
            return null;
        }
    }
}

