/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf.pool;

import de.siegmar.logbackgelf.pool.AbstractPooledObject;
import de.siegmar.logbackgelf.pool.PooledObjectConsumer;
import de.siegmar.logbackgelf.pool.PooledObjectFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SimpleObjectPool<T extends AbstractPooledObject> {
    private static final int MILLIS_PER_SECOND = 1000;
    private final BlockingQueue<T> pool = new LinkedBlockingQueue<T>();
    private final Set<T> allObjects = new HashSet<T>();
    private final PooledObjectFactory<T> objectFactory;
    private final int maxWaitTime;
    private final int maxLifeTime;

    public SimpleObjectPool(PooledObjectFactory<T> objectFactory, int poolSize, int maxWaitTime, int maxLifeTime) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be > 0");
        }
        this.objectFactory = objectFactory;
        this.maxWaitTime = maxWaitTime;
        this.maxLifeTime = maxLifeTime < 0 ? maxLifeTime : maxLifeTime * 1000;
        for (int i = 0; i < poolSize; ++i) {
            T pooledObject = this.objectFactory.newInstance();
            this.pool.add(pooledObject);
            this.allObjects.add(pooledObject);
        }
    }

    public void execute(PooledObjectConsumer<T> consumer) throws Exception {
        T pooledObject = null;
        try {
            pooledObject = this.borrowObject();
            consumer.accept(pooledObject);
        }
        catch (Exception e) {
            if (pooledObject != null) {
                this.invalidateObject(pooledObject);
                pooledObject = null;
            }
            throw e;
        }
        finally {
            if (pooledObject != null) {
                this.returnObject(pooledObject);
            }
        }
    }

    public T borrowObject() throws InterruptedException {
        AbstractPooledObject pooledObject;
        if (this.maxWaitTime < 0) {
            pooledObject = (AbstractPooledObject)this.pool.take();
        } else {
            pooledObject = (AbstractPooledObject)this.pool.poll(this.maxWaitTime, TimeUnit.MILLISECONDS);
            if (pooledObject == null) {
                throw new IllegalStateException("Couldn't acquire connection from pool");
            }
        }
        return (T)(this.needToEvict(pooledObject) ? this.recycle(pooledObject) : pooledObject);
    }

    private boolean needToEvict(T pooledObject) {
        return this.maxLifeTime < 0 || ((AbstractPooledObject)pooledObject).lifeTime() > (long)this.maxLifeTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T recycle(T oldInstance) {
        T newInstance = this.objectFactory.newInstance();
        Set<T> set = this.allObjects;
        synchronized (set) {
            this.allObjects.remove(oldInstance);
            this.allObjects.add(newInstance);
        }
        ((AbstractPooledObject)oldInstance).close();
        return newInstance;
    }

    public void returnObject(T pooledObject) {
        this.pool.add(pooledObject);
    }

    public void invalidateObject(T pooledObject) {
        this.pool.add(this.recycle(pooledObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Set<T> set = this.allObjects;
        synchronized (set) {
            for (AbstractPooledObject object : this.allObjects) {
                object.close();
            }
        }
    }
}

