/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.async.sse;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.ClockSingleton$;
import io.gatling.http.action.async.AsyncTx;
import io.gatling.http.action.async.OnFailedOpen;
import io.gatling.http.action.async.sse.Closed$;
import io.gatling.http.action.async.sse.EventStreamDispatcher;
import io.gatling.http.action.async.sse.OnClose$;
import io.gatling.http.action.async.sse.OnMessage;
import io.gatling.http.action.async.sse.OnOpen;
import io.gatling.http.action.async.sse.OnThrowable;
import io.gatling.http.action.async.sse.Open$;
import io.gatling.http.action.async.sse.Opening$;
import io.gatling.http.action.async.sse.ServerSentEvent;
import io.gatling.http.action.async.sse.SseState;
import io.gatling.http.action.async.sse.SseStream;
import io.gatling.http.action.async.sse.SseStreamDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.ws.http.HTTPException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.handler.ExtendedAsyncHandler;
import org.asynchttpclient.netty.LazyResponseBodyPart;
import org.asynchttpclient.netty.request.NettyRequest;
import org.asynchttpclient.util.HttpConstants;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001=\u0011!bU:f\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0002tg\u0016T!!\u0002\u0004\u0002\u000b\u0005\u001c\u0018P\\2\u000b\u0005\u001dA\u0011AB1di&|gN\u0003\u0002\n\u0015\u0005!\u0001\u000e\u001e;q\u0015\tYA\"A\u0004hCRd\u0017N\\4\u000b\u00035\t!![8\u0004\u0001M1\u0001\u0001\u0005\u0011$O)\u00022!\u0005\r\u001b\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dA\u0017M\u001c3mKJT!!\u0006\f\u0002\u001f\u0005\u001c\u0018P\\2iiR\u00048\r\\5f]RT\u0011aF\u0001\u0004_J<\u0017BA\r\u0013\u0005Q)\u0005\u0010^3oI\u0016$\u0017i]=oG\"\u000bg\u000e\u001a7feB\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5u!\t\t\u0012%\u0003\u0002#%\t1\u0012i]=oG\"\u000bg\u000e\u001a7fe\u0016CH/\u001a8tS>t7\u000f\u0005\u0002%K5\t!!\u0003\u0002'\u0005\tI1k]3TiJ,\u0017-\u001c\t\u0003I!J!!\u000b\u0002\u0003+\u00153XM\u001c;TiJ,\u0017-\u001c#jgB\fGo\u00195feB\u00111FM\u0007\u0002Y)\u0011QFL\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003_A\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002c\u0005\u00191m\\7\n\u0005Mb#!D*ue&\u001cG\u000fT8hO&tw\r\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0003\t!\b\u0010\u0005\u00028q5\tA!\u0003\u0002:\t\t9\u0011i]=oGRC\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0011M\u001cX-Q2u_J\u0004\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003\u0005\u000bA!Y6lC&\u00111I\u0010\u0002\t\u0003\u000e$xN\u001d*fM\")Q\t\u0001C\u0001\r\u00061A(\u001b8jiz\"2a\u0012%J!\t!\u0003\u0001C\u00036\t\u0002\u0007a\u0007C\u0003<\t\u0002\u0007A\bC\u0004L\u0001\t\u0007I\u0011\u0002'\u0002\t\u0011|g.Z\u000b\u0002\u001bB\u0011ajV\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0007CR|W.[2\u000b\u0005I\u001b\u0016AC2p]\u000e,(O]3oi*\u0011A+V\u0001\u0005kRLGNC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a{%!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004[\u0001\u0001\u0006I!T\u0001\u0006I>tW\r\t\u0005\b9\u0002\u0001\r\u0011\"\u0003^\u0003\u0015\u0019H/\u0019;f+\u0005q\u0006C\u0001\u0013`\u0013\t\u0001'A\u0001\u0005Tg\u0016\u001cF/\u0019;f\u0011\u001d\u0011\u0007\u00011A\u0005\n\r\f\u0011b\u001d;bi\u0016|F%Z9\u0015\u0005i!\u0007bB3b\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\n\u0004BB4\u0001A\u0003&a,\u0001\u0004ti\u0006$X\r\t\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0003\u001d!WmY8eKJ,\u0012a\u001b\t\u0003I1L!!\u001c\u0002\u0003!M\u001bXm\u0015;sK\u0006lG)Z2pI\u0016\u0014\bBB8\u0001A\u0003%1.\u0001\u0005eK\u000e|G-\u001a:!\u0011\u0015\t\b\u0001\"\u0011s\u0003Myg\u000eV2q\u0007>tg.Z2u'V\u001c7-Z:t)\rQ2o\u001f\u0005\u0006iB\u0004\r!^\u0001\bC\u0012$'/Z:t!\t1\u00180D\u0001x\u0015\tAX+A\u0002oKRL!A_<\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8\u000fC\u0003}a\u0002\u0007Q0\u0001\u0006d_:tWm\u0019;j_:\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tqa\u00195b]:,GNC\u0002\u0002\u00061\tQA\\3uifL1!!\u0003\u0000\u0005\u001d\u0019\u0005.\u00198oK2Dq!!\u0004\u0001\t\u0003\ny!A\u0004p]J+GO]=\u0015\u0003iAq!a\u0005\u0001\t\u0003\n)\"A\u0007p]J+\u0017/^3tiN+g\u000e\u001a\u000b\u00045\u0005]\u0001\u0002CA\r\u0003#\u0001\r!a\u0007\u0002\u000fI,\u0017/^3tiB!\u0011QDA\u0012\u001b\t\tyB\u0003\u0003\u0002\u001a\u0005\u0005\"bAA\u0003)%!\u0011QEA\u0010\u00051qU\r\u001e;z%\u0016\fX/Z:u\u0011\u001d\tI\u0003\u0001C!\u0003W\t\u0001c\u001c8Ti\u0006$Xo\u001d*fG\u0016Lg/\u001a3\u0015\t\u00055\u0012\u0011\n\t\u0005\u0003_\t\u0019E\u0004\u0003\u00022\u0005}b\u0002BA\u001a\u0003{qA!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sq\u0011A\u0002\u001fs_>$h(C\u0001\u0018\u0013\t)b#C\u0002\u0002BQ\tA\"Q:z]\u000eD\u0015M\u001c3mKJLA!!\u0012\u0002H\t)1\u000b^1uK*\u0019\u0011\u0011\t\u000b\t\u0011\u0005-\u0013q\u0005a\u0001\u0003\u001b\naB]3ta>t7/Z*uCR,8\u000f\u0005\u0003\u0002P\u0005ES\"\u0001\u000b\n\u0007\u0005MCC\u0001\nIiR\u0004(+Z:q_:\u001cXm\u0015;biV\u001c\bbBA,\u0001\u0011\u0005\u0013\u0011L\u0001\u0012_:DU-\u00193feN\u0014VmY3jm\u0016$G\u0003BA\u0017\u00037B\u0001\"!\u0018\u0002V\u0001\u0007\u0011qL\u0001\bQ\u0016\fG-\u001a:t!\u0011\ty%!\u0019\n\u0007\u0005\rDCA\nIiR\u0004(+Z:q_:\u001cX\rS3bI\u0016\u00148\u000fC\u0004\u0002h\u0001!\t%!\u001b\u0002%=t'i\u001c3z!\u0006\u0014HOU3dK&4X\r\u001a\u000b\u0005\u0003[\tY\u0007\u0003\u0005\u0002n\u0005\u0015\u0004\u0019AA8\u0003!\u0011w\u000eZ=QCJ$\b\u0003BA(\u0003cJ1!a\u001d\u0015\u0005QAE\u000f\u001e9SKN\u0004xN\\:f\u0005>$\u0017\u0010U1si\"9\u0011q\u000f\u0001\u0005B\u0005=\u0011aC8o\u0007>l\u0007\u000f\\3uK\u0012Dq!a\u001f\u0001\t\u0003\ni(A\u0006p]RC'o\\<bE2,Gc\u0001\u000e\u0002\u0000!A\u0011\u0011QA=\u0001\u0004\t\u0019)A\u0005uQJ|w/\u00192mKB!\u0011QQAH\u001d\u0011\t9)a#\u000f\t\u0005U\u0012\u0011R\u0005\u0002;%\u0019\u0011Q\u0012\u000f\u0002\u000fA\f7m[1hK&!\u0011\u0011SAJ\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\u000erAq!a&\u0001\t\u0003\tI*A\btK:$wJ\u001c+ie><\u0018M\u00197f)\rQ\u00121\u0014\u0005\t\u0003\u0003\u000b)\n1\u0001\u0002\u0004\"9\u0011q\u0014\u0001\u0005B\u0005=\u0011!B2m_N,\u0007bBAR\u0001\u0011\u0005\u0013QU\u0001\u0014I&\u001c\b/\u0019;dQ\u00163XM\u001c;TiJ,\u0017-\u001c\u000b\u00045\u0005\u001d\u0006bB\u0002\u0002\"\u0002\u0007\u0011\u0011\u0016\t\u0004I\u0005-\u0016bAAW\u0005\ty1+\u001a:wKJ\u001cVM\u001c;Fm\u0016tG\u000f")
public class SseHandler
extends ExtendedAsyncHandler<BoxedUnit>
implements SseStream,
EventStreamDispatcher,
StrictLogging {
    private final AsyncTx tx;
    private final ActorRef sseActor;
    private final AtomicBoolean done;
    private SseState state;
    private final SseStreamDecoder decoder;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private AtomicBoolean done() {
        return this.done;
    }

    private SseState state() {
        return this.state;
    }

    private void state_$eq(SseState x$1) {
        this.state = x$1;
    }

    private SseStreamDecoder decoder() {
        return this.decoder;
    }

    public void onTcpConnectSuccess(InetSocketAddress address, Channel connection) {
        this.state_$eq(Open$.MODULE$);
    }

    public void onRetry() {
        block2: {
            BoxedUnit boxedUnit;
            if (!this.done().get()) break block2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("onRetry is not supposed to be called once done");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void onRequestSend(NettyRequest request) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Request {} has been sent by the http client", new Object[]{request});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) {
        AsyncHandler.State state;
        BoxedUnit boxedUnit;
        int statusCode = responseStatus.getStatusCode();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Status {} received for sse '{}", new Object[]{BoxesRunTime.boxToInteger((int)statusCode), this.tx.requestName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (statusCode == HttpConstants.ResponseStatusCodes.OK_200) {
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.sseActor);
            OnOpen x$1 = new OnOpen(this.tx, this, ClockSingleton$.MODULE$.nowMillis());
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
            state = AsyncHandler.State.CONTINUE;
        } else {
            this.onThrowable((Throwable)new HTTPException(null, statusCode){
                private final int statusCode$1;

                public String getMessage() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server returned http response with code ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.statusCode$1)}));
                }
                {
                    this.statusCode$1 = statusCode$1;
                    super(statusCode$1);
                }
            });
            state = AsyncHandler.State.ABORT;
        }
        return state;
    }

    public AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) {
        return this.done().get() ? AsyncHandler.State.ABORT : AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) {
        AsyncHandler.State state;
        if (this.done().get()) {
            state = AsyncHandler.State.ABORT;
        } else {
            ByteBuf byteBuf = ((LazyResponseBodyPart)bodyPart).getBuf();
            Seq<ServerSentEvent> events = this.decoder().decodeStream(byteBuf);
            events.foreach((Function1 & Serializable & scala.Serializable)sse -> {
                this.dispatchEventStream(sse);
                return BoxedUnit.UNIT;
            });
            state = AsyncHandler.State.CONTINUE;
        }
        return state;
    }

    public void onCompleted() {
        block0: {
            if (!this.done().compareAndSet(false, true)) break block0;
            ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.sseActor);
            OnClose$ x$3 = OnClose$.MODULE$;
            ActorRef x$4 = qual$2.$bang$default$2((Object)x$3);
            qual$2.$bang((Object)x$3, x$4);
        }
    }

    public void onThrowable(Throwable throwable) {
        block0: {
            if (!this.done().compareAndSet(false, true)) break block0;
            this.sendOnThrowable(throwable);
        }
    }

    public void sendOnThrowable(Throwable throwable) {
        BoxedUnit boxedUnit;
        String className = throwable.getClass().getName();
        String string = throwable.getMessage();
        String string2 = string == null ? className : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className, string}));
        String errorMessage = string2;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request '", "' failed for user ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tx.requestName(), BoxesRunTime.boxToLong((long)this.tx.session().userId())})), throwable);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Request '{}' failed for user {}: {}", new Object[]{this.tx.requestName(), BoxesRunTime.boxToLong((long)this.tx.session().userId()), errorMessage});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SseState sseState = this.state();
        if (Opening$.MODULE$.equals(sseState)) {
            ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.sseActor);
            OnFailedOpen x$5 = new OnFailedOpen(this.tx, errorMessage, ClockSingleton$.MODULE$.nowMillis());
            ActorRef x$6 = qual$3.$bang$default$2((Object)x$5);
            qual$3.$bang((Object)x$5, x$6);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (Open$.MODULE$.equals(sseState)) {
            ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.sseActor);
            OnThrowable x$7 = new OnThrowable(this.tx, errorMessage, ClockSingleton$.MODULE$.nowMillis());
            ActorRef x$8 = qual$4.$bang$default$2((Object)x$7);
            qual$4.$bang((Object)x$7, x$8);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else if (Closed$.MODULE$.equals(sseState)) {
            BoxedUnit boxedUnit4;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("unexpected state closed with error message: {}", new Object[]{errorMessage});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit4;
        } else {
            throw new MatchError((Object)sseState);
        }
    }

    @Override
    public void close() {
        this.onCompleted();
    }

    @Override
    public void dispatchEventStream(ServerSentEvent sse) {
        ScalaActorRef qual$5 = package$.MODULE$.actorRef2Scala(this.sseActor);
        OnMessage x$9 = new OnMessage(sse.asJsonString(), ClockSingleton$.MODULE$.nowMillis());
        ActorRef x$10 = qual$5.$bang$default$2((Object)x$9);
        qual$5.$bang((Object)x$9, x$10);
    }

    public SseHandler(AsyncTx tx, ActorRef sseActor) {
        this.tx = tx;
        this.sseActor = sseActor;
        StrictLogging.$init$((StrictLogging)this);
        this.done = new AtomicBoolean();
        this.state = Opening$.MODULE$;
        this.decoder = new SseStreamDecoder();
    }
}

