/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sync;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.ClockSingleton$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.util.NameGen;
import io.gatling.http.action.sync.HttpTx;
import io.gatling.http.ahc.HttpEngine;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.fetch.RegularResourceFetched;
import io.gatling.http.fetch.ResourceFetcherActor;
import io.gatling.http.protocol.HttpProtocolRequestPart;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.response.ResponseBuilder;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Request;
import org.asynchttpclient.uri.Uri;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class HttpTx$
implements NameGen,
StrictLogging,
scala.Serializable {
    public static HttpTx$ MODULE$;
    private final Logger logger;

    static {
        new HttpTx$();
    }

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Option<ActorRef> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public int $lessinit$greater$default$6() {
        return 0;
    }

    public Function1<Session, Session> $lessinit$greater$default$7() {
        return Session$.MODULE$.Identity();
    }

    public boolean silent(HttpRequest request, boolean root) {
        boolean bl;
        HttpProtocolRequestPart requestPart = request.config().httpComponents().httpProtocol().requestPart();
        Option<Object> option = request.config().silent();
        if (None$.MODULE$.equals(option)) {
            bl = HttpTx$.silentBecauseProtocolSilentURI$1(request, requestPart) || HttpTx$.silentBecauseProtocolSilentResources$1(root, requestPart);
        } else if (option instanceof Some) {
            boolean silent;
            Some some = (Some)option;
            bl = silent = BoxesRunTime.unboxToBoolean((Object)some.value());
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void startWithCache(HttpTx origTx, ActorRefFactory actorRefFactory, HttpEngine httpEngine, HttpCaches httpCaches, Function1<HttpTx, BoxedUnit> f) {
        Option<Function0<ResourceFetcherActor>> option;
        Option<Object> option2;
        Some some;
        ContentCacheEntry contentCacheEntry;
        Option<Object> option3;
        Some some2;
        ContentCacheEntry contentCacheEntry2;
        HttpTx tx = httpCaches.applyPermanentRedirect(origTx);
        Request ahcRequest = tx.request().ahcRequest();
        Uri uri = ahcRequest.getUri();
        Option<ContentCacheEntry> option4 = httpCaches.contentCacheEntry(tx.session(), ahcRequest);
        boolean bl = None$.MODULE$.equals(option4) ? true : option4 instanceof Some && (contentCacheEntry2 = (ContentCacheEntry)(some2 = (Some)option4).value()) != null && None$.MODULE$.equals(option3 = contentCacheEntry2.expires());
        if (bl) {
            BoxedUnit boxedUnit = (BoxedUnit)f.apply((Object)tx);
            return;
        }
        if (option4 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option4).value()) != null && (option2 = contentCacheEntry.expires()) instanceof Some) {
            Some some3 = (Some)option2;
            long expire = BoxesRunTime.unboxToLong((Object)some3.value());
            if (ClockSingleton$.MODULE$.unpreciseNowMillis() > expire) {
                HttpTx newTx = tx.copy(httpCaches.clearContentCache(tx.session(), ahcRequest), tx.copy$default$2(), tx.copy$default$3(), tx.copy$default$4(), tx.copy$default$5(), tx.copy$default$6(), tx.copy$default$7());
                BoxedUnit boxedUnit = (BoxedUnit)f.apply((Object)newTx);
                return;
            }
        }
        if ((option = httpEngine.resourceFetcherActorForCachedPage(uri, tx)) instanceof Some) {
            BoxedUnit boxedUnit;
            Some some4 = (Some)option;
            Function0 resourceFetcherActor = (Function0)some4.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Fetching resources of cached page request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), uri, tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            actorRefFactory.actorOf(Props$.MODULE$.apply(resourceFetcherActor, ClassTag$.MODULE$.apply(ResourceFetcherActor.class)), this.genName("resourceFetcher"));
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Skipping cached request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), uri, tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option<ActorRef> option5 = tx.resourceFetcher();
            if (None$.MODULE$.equals(option5)) {
                tx.next().$bang(tx.session());
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            } else {
                if (!(option5 instanceof Some)) throw new MatchError(option5);
                Some some5 = (Some)option5;
                ActorRef resourceFetcher = (ActorRef)some5.value();
                ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(resourceFetcher);
                RegularResourceFetched x$1 = new RegularResourceFetched(uri, (Status)OK$.MODULE$, (Function1<Session, Session>)Session$.MODULE$.Identity(), tx.silent());
                ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
                qual$1.$bang((Object)x$1, x$2);
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void executeRequest(AsyncHttpClient client, Request ahcRequest, io.gatling.http.ahc.AsyncHandler handler) {
        block0: {
            if (client.isClosed()) break block0;
            handler.start();
            client.executeRequest(ahcRequest, (AsyncHandler)handler);
        }
    }

    public void start(HttpTx origTx, ActorRefFactory actorRefFactory) {
        this.startWithCache(origTx, actorRefFactory, origTx.request().config().httpComponents().httpEngine(), origTx.request().config().httpComponents().httpCaches(), (Function1<HttpTx, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tx -> {
            HttpTx$.$anonfun$start$1(origTx, tx);
            return BoxedUnit.UNIT;
        });
    }

    public HttpTx apply(Session session, HttpRequest request, Function1<Request, ResponseBuilder> responseBuilderFactory, Action next, Option<ActorRef> resourceFetcher, int redirectCount, Function1<Session, Session> update) {
        return new HttpTx(session, request, responseBuilderFactory, next, resourceFetcher, redirectCount, update);
    }

    public Option<ActorRef> apply$default$5() {
        return None$.MODULE$;
    }

    public int apply$default$6() {
        return 0;
    }

    public Function1<Session, Session> apply$default$7() {
        return Session$.MODULE$.Identity();
    }

    public Option<Tuple7<Session, HttpRequest, Function1<Request, ResponseBuilder>, Action, Option<ActorRef>, Object, Function1<Session, Session>>> unapply(HttpTx x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.session(), (Object)x$0.request(), x$0.responseBuilderFactory(), (Object)x$0.next(), x$0.resourceFetcher(), (Object)BoxesRunTime.boxToInteger((int)x$0.redirectCount()), x$0.update()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final boolean silentBecauseProtocolSilentURI$1(HttpRequest request$1, HttpProtocolRequestPart requestPart$1) {
        boolean bl;
        Option<Pattern> option = requestPart$1.silentURI();
        if (option instanceof Some) {
            Some some = (Some)option;
            Pattern silentUri = (Pattern)some.value();
            bl = silentUri.matcher(request$1.ahcRequest().getUrl()).matches();
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    private static final boolean silentBecauseProtocolSilentResources$1(boolean root$1, HttpProtocolRequestPart requestPart$1) {
        return !root$1 && requestPart$1.silentResources();
    }

    public static final /* synthetic */ void $anonfun$start$1(HttpTx origTx$1, HttpTx tx) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("Sending request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), tx.request().ahcRequest().getUri(), tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Tuple2<Session, AsyncHttpClient> tuple2 = origTx$1.request().config().httpComponents().httpEngine().httpClient(tx.session(), origTx$1.request().config().httpComponents().httpProtocol());
        if (tuple2 != null) {
            BoxedUnit boxedUnit2;
            Session newSession = (Session)tuple2._1();
            AsyncHttpClient client = (AsyncHttpClient)tuple2._2();
            HttpTx newTx = tx.copy(newSession, tx.copy$default$2(), tx.copy$default$3(), tx.copy$default$4(), tx.copy$default$5(), tx.copy$default$6(), tx.copy$default$7());
            Request ahcRequest = newTx.request().ahcRequest();
            io.gatling.http.ahc.AsyncHandler handler = new io.gatling.http.ahc.AsyncHandler(newTx, origTx$1.request().config().httpComponents().responseProcessor());
            if (tx.request().config().throttled()) {
                origTx$1.request().config().coreComponents().throttler().throttle(tx.session().scenario(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.executeRequest(client, ahcRequest, handler));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                MODULE$.executeRequest(client, ahcRequest, handler);
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
        } else {
            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
        }
    }

    private HttpTx$() {
        MODULE$ = this;
        NameGen.$init$((NameGen)this);
        StrictLogging.$init$((StrictLogging)this);
    }
}

