/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.CoreComponents;
import io.gatling.core.filter.Filters;
import io.gatling.core.session.Session;
import io.gatling.core.util.cache.Cache$;
import io.gatling.http.action.sync.HttpTx;
import io.gatling.http.ahc.HttpEngine;
import io.gatling.http.fetch.EmbeddedResource;
import io.gatling.http.fetch.HtmlParser;
import io.gatling.http.fetch.InferredPageResources;
import io.gatling.http.fetch.InferredResourcesCacheKey;
import io.gatling.http.fetch.ResourceFetcherActor;
import io.gatling.http.fetch.UserAgent$;
import io.gatling.http.fetch.package$;
import io.gatling.http.fetch.package$EmbeddedResourcesFilters$;
import io.gatling.http.protocol.HttpComponents;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.request.HttpRequestDef;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import org.asynchttpclient.Request;
import org.asynchttpclient.uri.Uri;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee!C\u0001\u0003!\u0003\r\taCAC\u0005=\u0011Vm]8ve\u000e,g)\u001a;dQ\u0016\u0014(BA\u0002\u0005\u0003\u00151W\r^2i\u0015\t)a!\u0001\u0003iiR\u0004(BA\u0004\t\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!C\u0001\u0003S>\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQa\u0005\u0001\u0005\u0002Q\ta\u0001J5oSR$C#A\u000b\u0011\u000551\u0012BA\f\u000f\u0005\u0011)f.\u001b;\t\u000fe\u0001!\u0019!C\u00015\u0005y1i]:D_:$XM\u001c;DC\u000eDW-F\u0001\u001c!\u0011a2%J\u0018\u000e\u0003uQ!AH\u0010\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002!C\u0005!Q\u000f^5m\u0015\u0005\u0011\u0013\u0001\u00026bm\u0006L!\u0001J\u000f\u0003\u001b\r{gnY;se\u0016tG/T1q!\t1S&D\u0001(\u0015\tA\u0013&A\u0002ve&T!AK\u0016\u0002\u001f\u0005\u001c\u0018P\\2iiR\u00048\r\\5f]RT\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018(\u0005\r)&/\u001b\t\u0004aaZdBA\u00197\u001d\t\u0011T'D\u00014\u0015\t!$\"\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011qGD\u0001\ba\u0006\u001c7.Y4f\u0013\tI$H\u0001\u0003MSN$(BA\u001c\u000f!\taT(D\u0001\u0003\u0013\tq$A\u0001\tF[\n,G\rZ3e%\u0016\u001cx.\u001e:dK\"9\u0001\t\u0001b\u0001\n\u0003\t\u0015AF%oM\u0016\u0014(/\u001a3SKN|WO]2fg\u000e\u000b7\r[3\u0016\u0003\t\u0003B\u0001H\u0012D\rB\u0011A\bR\u0005\u0003\u000b\n\u0011\u0011$\u00138gKJ\u0014X\r\u001a*fg>,(oY3t\u0007\u0006\u001c\u0007.Z&fsB\u0011AhR\u0005\u0003\u0011\n\u0011Q#\u00138gKJ\u0014X\r\u001a)bO\u0016\u0014Vm]8ve\u000e,7\u000fC\u0003K\u0001\u0011\u00051*\u0001\u000bbaBd\u0017PU3t_V\u00148-\u001a$jYR,'o\u001d\u000b\u0004_1s\u0005\"B'J\u0001\u0004y\u0013!\u0003:fg>,(oY3t\u0011\u0015y\u0015\n1\u0001Q\u0003\u001d1\u0017\u000e\u001c;feN\u00042!D)T\u0013\t\u0011fB\u0001\u0004PaRLwN\u001c\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000baAZ5mi\u0016\u0014(B\u0001-\u0007\u0003\u0011\u0019wN]3\n\u0005i+&a\u0002$jYR,'o\u001d\u0005\u00069\u0002!\t!X\u0001\u0014e\u0016\u001cx.\u001e:dKN$vNU3rk\u0016\u001cHo\u001d\u000b\u0007=\u00164Wn]>\u0011\u0007ABt\f\u0005\u0002aG6\t\u0011M\u0003\u0002c\t\u00059!/Z9vKN$\u0018B\u00013b\u0005-AE\u000f\u001e9SKF,Xm\u001d;\t\u000b5[\u0006\u0019A\u0018\t\u000b\u001d\\\u0006\u0019\u00015\u0002\u000fM,7o]5p]B\u0011\u0011n[\u0007\u0002U*\u0011qmV\u0005\u0003Y*\u0014qaU3tg&|g\u000eC\u0003o7\u0002\u0007q.\u0001\bd_J,7i\\7q_:,g\u000e^:\u0011\u0005A\fX\"A,\n\u0005I<&AD\"pe\u0016\u001cu.\u001c9p]\u0016tGo\u001d\u0005\u0006in\u0003\r!^\u0001\u000fQR$\boQ8na>tWM\u001c;t!\t1\u00180D\u0001x\u0015\tAH!\u0001\u0005qe>$xnY8m\u0013\tQxO\u0001\bIiR\u00048i\\7q_:,g\u000e^:\t\u000bq\\\u0006\u0019A?\u0002\u0013QD'o\u001c;uY\u0016$\u0007CA\u0007\u007f\u0013\tyhBA\u0004C_>dW-\u00198\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006\u0005\u0011\u0012N\u001c4feB\u000bw-\u001a*fg>,(oY3t)%q\u0016qAA\t\u0003?\t\t\u0003C\u0004c\u0003\u0003\u0001\r!!\u0003\u0011\t\u0005-\u0011QB\u0007\u0002S%\u0019\u0011qB\u0015\u0003\u000fI+\u0017/^3ti\"A\u00111CA\u0001\u0001\u0004\t)\"\u0001\u0005sKN\u0004xN\\:f!\u0011\t9\"a\u0007\u000e\u0005\u0005e!bAA\n\t%!\u0011QDA\r\u0005!\u0011Vm\u001d9p]N,\u0007BB4\u0002\u0002\u0001\u0007\u0001\u000e\u0003\u0005\u0002$\u0005\u0005\u0001\u0019AA\u0013\u0003\u0019\u0019wN\u001c4jOB\u0019\u0001-a\n\n\u0007\u0005%\u0012MA\tIiR\u0004(+Z9vKN$8i\u001c8gS\u001eDq!!\f\u0001\t\u0013\ty#\u0001\fck&dG-\u0012=qY&\u001c\u0017\u000e\u001e*fg>,(oY3t)\u0015q\u0016\u0011GA\u001e\u0011\u001di\u00151\u0006a\u0001\u0003g\u0001B\u0001\r\u001d\u00026A\u0019\u0001-a\u000e\n\u0007\u0005e\u0012M\u0001\bIiR\u0004(+Z9vKN$H)\u001a4\t\r\u001d\fY\u00031\u0001i\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003\nAC]3t_V\u00148-\u001a$fi\u000eDWM]!di>\u0014H\u0003CA\"\u0003#\n)'!\u001b\u0011\t5\t\u0016Q\t\t\u0006\u001b\u0005\u001d\u00131J\u0005\u0004\u0003\u0013r!!\u0003$v]\u000e$\u0018n\u001c81!\ra\u0014QJ\u0005\u0004\u0003\u001f\u0012!\u0001\u0006*fg>,(oY3GKR\u001c\u0007.\u001a:BGR|'\u000f\u0003\u0005\u0002T\u0005u\u0002\u0019AA+\u0003\t!\b\u0010\u0005\u0003\u0002X\u0005\u0005TBAA-\u0015\u0011\tY&!\u0018\u0002\tMLhn\u0019\u0006\u0004\u0003?\"\u0011AB1di&|g.\u0003\u0003\u0002d\u0005e#A\u0002%uiB$\u0006\u0010C\u0004\u0002h\u0005u\u0002\u0019\u00010\u0002#%tg-\u001a:sK\u0012\u0014Vm]8ve\u000e,7\u000fC\u0004\u0002l\u0005u\u0002\u0019\u00010\u0002#\u0015D\b\u000f\\5dSR\u0014Vm]8ve\u000e,7\u000fC\u0004\u0002p\u0001!\t!!\u001d\u0002CI,7o\\;sG\u00164U\r^2iKJ\f5\r^8s\r>\u00148)Y2iK\u0012\u0004\u0016mZ3\u0015\r\u0005\r\u00131OA<\u0011\u001d\t)(!\u001cA\u0002\u0015\nq\u0002\u001b;nY\u0012{7-^7f]R,&+\u0013\u0005\t\u0003'\ni\u00071\u0001\u0002V!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014A\t:fg>,(oY3GKR\u001c\u0007.\u001a:BGR|'OR8s\r\u0016$8\r[3e!\u0006<W\r\u0006\u0005\u0002D\u0005}\u0014\u0011QAB\u0011\u001d\u0011\u0017\u0011\u0010a\u0001\u0003\u0013A\u0001\"a\u0005\u0002z\u0001\u0007\u0011Q\u0003\u0005\t\u0003'\nI\b1\u0001\u0002VA!\u0011qQAG\u001b\t\tIIC\u0002\u0002\f\u0012\t1!\u00195d\u0013\u0011\ty)!#\u0003\u0015!#H\u000f]#oO&tW\r")
public interface ResourceFetcher {
    public void io$gatling$http$fetch$ResourceFetcher$_setter_$CssContentCache_$eq(ConcurrentMap<Uri, List<EmbeddedResource>> var1);

    public void io$gatling$http$fetch$ResourceFetcher$_setter_$InferredResourcesCache_$eq(ConcurrentMap<InferredResourcesCacheKey, InferredPageResources> var1);

    public ConcurrentMap<Uri, List<EmbeddedResource>> CssContentCache();

    public ConcurrentMap<InferredResourcesCacheKey, InferredPageResources> InferredResourcesCache();

    public static /* synthetic */ List applyResourceFilters$(ResourceFetcher $this, List resources, Option filters) {
        return $this.applyResourceFilters((List<EmbeddedResource>)resources, (Option<Filters>)filters);
    }

    default public List<EmbeddedResource> applyResourceFilters(List<EmbeddedResource> resources, Option<Filters> filters) {
        List<EmbeddedResource> list;
        Option<Filters> option = filters;
        if (option instanceof Some) {
            Some some = (Some)option;
            Filters f = (Filters)some.value();
            list = package$EmbeddedResourcesFilters$.MODULE$.filter$extension(package$.MODULE$.EmbeddedResourcesFilters(f), resources);
        } else {
            list = resources;
        }
        return list;
    }

    public static /* synthetic */ List resourcesToRequests$(ResourceFetcher $this, List resources, Session session, CoreComponents coreComponents, HttpComponents httpComponents, boolean throttled) {
        return $this.resourcesToRequests((List<EmbeddedResource>)resources, session, coreComponents, httpComponents, throttled);
    }

    default public List<HttpRequest> resourcesToRequests(List<EmbeddedResource> resources, Session session, CoreComponents coreComponents, HttpComponents httpComponents, boolean throttled) {
        return (List)resources.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
            Iterable iterable;
            Validation<HttpRequest> validation = x$1.toRequest(session, coreComponents, httpComponents, throttled);
            if (validation instanceof Success) {
                Success success = (Success)validation;
                HttpRequest httpRequest = (HttpRequest)success.value();
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)httpRequest));
            } else if (validation instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)validation;
                String m = failure.message();
                if (((StrictLogging)this).logger().underlying().isErrorEnabled()) {
                    ((StrictLogging)this).logger().underlying().error("Could build request for embedded resource: " + m);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                throw new MatchError(validation);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    private List<HttpRequest> inferPageResources(Request request, Response response, Session session, HttpRequestConfig config) {
        block13: {
            block10: {
                block12: {
                    block11: {
                        htmlDocumentUri = response.request().getUri();
                        coreComponents = config.coreComponents();
                        httpComponents = config.httpComponents();
                        httpProtocol = httpComponents.httpProtocol();
                        var13_9 = false;
                        var14_10 = null;
                        var15_11 = response.statusCode();
                        if (!(var15_11 instanceof Some)) break block10;
                        var13_9 = true;
                        var14_10 = (Some)var15_11;
                        var16_12 = BoxesRunTime.unboxToInt((Object)var14_10.value());
                        if (200 != var16_12) break block10;
                        var17_13 = response.lastModifiedOrEtag(httpProtocol);
                        if (!(var17_13 instanceof Some)) break block11;
                        var18_14 = (Some)var17_13;
                        newLastModifiedOrEtag = (String)var18_14.value();
                        cacheKey = new InferredResourcesCacheKey(httpProtocol, htmlDocumentUri);
                        var21_17 = Option$.MODULE$.apply(this.InferredResourcesCache().get(cacheKey));
                        if (!(var21_17 instanceof Some) || (var23_19 = (InferredPageResources)(var22_18 = (Some)var21_17).value()) == null) ** GOTO lbl-1000
                        var24_20 = var23_19.expire();
                        res = var23_19.requests();
                        v0 = newLastModifiedOrEtag;
                        var26_22 = var24_20;
                        if (!(v0 != null ? v0.equals(var26_22) == false : var26_22 != null)) {
                            var8_23 = res;
                        } else lbl-1000:
                        // 2 sources

                        {
                            inferredResources = this.inferredResourcesRequests$1(request, response, session, config, htmlDocumentUri, coreComponents, httpComponents, httpProtocol);
                            this.InferredResourcesCache().put(cacheKey, new InferredPageResources(newLastModifiedOrEtag, inferredResources));
                            var8_23 = inferredResources;
                        }
                        var7_25 = var8_23;
                        break block12;
                    }
                    if (None$.MODULE$.equals(var17_13)) {
                        var7_25 = this.inferredResourcesRequests$1(request, response, session, config, htmlDocumentUri, coreComponents, httpComponents, httpProtocol);
                    } else {
                        throw new MatchError(var17_13);
                    }
                }
                var5_26 = var7_25;
                break block13;
            }
            if (var13_9 && 304 == (var28_27 = BoxesRunTime.unboxToInt((Object)var14_10.value()))) {
                var29_28 = (InferredPageResources)this.InferredResourcesCache().get(new InferredResourcesCacheKey(httpProtocol, htmlDocumentUri));
                if (var29_28 == null) {
                    if (((StrictLogging)this).logger().underlying().isWarnEnabled()) {
                        ((StrictLogging)this).logger().underlying().warn("Got a 304 for {} but could find cache entry?!", new Object[]{htmlDocumentUri});
                        v1 = BoxedUnit.UNIT;
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                    var6_29 = Nil$.MODULE$;
                } else {
                    var6_29 = var29_28.requests();
                }
                var5_26 = var6_29;
            } else {
                var5_26 = Nil$.MODULE$;
            }
        }
        return var5_26;
    }

    private List<HttpRequest> buildExplicitResources(List<HttpRequestDef> resources, Session session) {
        return (List)resources.flatMap((Function1 & Serializable & scala.Serializable)resource -> {
            Iterable iterable;
            Validation validation = (Validation)resource.requestName().apply((Object)session);
            if (validation instanceof Success) {
                Iterable iterable2;
                Success success = (Success)validation;
                String requestName = (String)success.value();
                Validation<HttpRequest> validation2 = resource.build(requestName, session);
                if (validation2 instanceof Success) {
                    Success success2 = (Success)validation2;
                    HttpRequest httpRequest = (HttpRequest)success2.value();
                    iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)httpRequest));
                } else if (validation2 instanceof Failure) {
                    Failure failure = (Failure)validation2;
                    String m = failure.message();
                    ((HttpEngine)this).coreComponents().statsEngine().reportUnbuildableRequest(session, requestName, m);
                    iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    throw new MatchError(validation2);
                }
                iterable = iterable2;
            } else if (validation instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)validation;
                String m = failure.message();
                if (((StrictLogging)this).logger().underlying().isErrorEnabled()) {
                    ((StrictLogging)this).logger().underlying().error("Could build request name for explicitResource: " + m);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                throw new MatchError((Object)validation);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom());
    }

    private Option<Function0<ResourceFetcherActor>> resourceFetcherActor(HttpTx tx, List<HttpRequest> inferredResources, List<HttpRequest> explicitResources) {
        None$ none$;
        List<HttpRequest> list = inferredResources;
        List list2 = explicitResources.$colon$colon$colon(list);
        if (Nil$.MODULE$.equals(list2)) {
            none$ = None$.MODULE$;
        } else {
            HttpEngine resourceFetcher = (HttpEngine)this;
            none$ = new Some((Function0 & Serializable & scala.Serializable)() -> new ResourceFetcherActor(tx, (Seq<HttpRequest>)list2));
        }
        return none$;
    }

    public static /* synthetic */ Option resourceFetcherActorForCachedPage$(ResourceFetcher $this, Uri htmlDocumentURI, HttpTx tx) {
        return $this.resourceFetcherActorForCachedPage(htmlDocumentURI, tx);
    }

    default public Option<Function0<ResourceFetcherActor>> resourceFetcherActorForCachedPage(Uri htmlDocumentURI, HttpTx tx) {
        InferredPageResources inferredPageResources = (InferredPageResources)this.InferredResourcesCache().get(new InferredResourcesCacheKey(tx.request().config().httpComponents().httpProtocol(), htmlDocumentURI));
        List<HttpRequest> list = inferredPageResources == null ? Nil$.MODULE$ : inferredPageResources.requests();
        List<HttpRequest> inferredResources = list;
        List<HttpRequest> explicitResources = this.buildExplicitResources(tx.request().config().explicitResources(), tx.session());
        return this.resourceFetcherActor(tx, inferredResources, explicitResources);
    }

    public static /* synthetic */ Option resourceFetcherActorForFetchedPage$(ResourceFetcher $this, Request request, Response response, HttpTx tx) {
        return $this.resourceFetcherActorForFetchedPage(request, response, tx);
    }

    default public Option<Function0<ResourceFetcherActor>> resourceFetcherActorForFetchedPage(Request request, Response response, HttpTx tx) {
        HttpProtocol httpProtocol = tx.request().config().httpComponents().httpProtocol();
        List<HttpRequest> explicitResources = tx.request().config().explicitResources().nonEmpty() ? this.buildExplicitResources(tx.request().config().explicitResources(), tx.session()) : Nil$.MODULE$;
        List<HttpRequest> inferredResources = httpProtocol.responsePart().inferHtmlResources() && response.isReceived() && HttpHelper$.MODULE$.isHtml(response.headers()) ? this.inferPageResources(request, response, tx.session(), tx.request().config()) : Nil$.MODULE$;
        return this.resourceFetcherActor(tx, inferredResources, explicitResources);
    }

    private List inferredResourcesRequests$1(Request request$1, Response response$1, Session session$2, HttpRequestConfig config$1, Uri htmlDocumentUri$1, CoreComponents coreComponents$2, HttpComponents httpComponents$2, HttpProtocol httpProtocol$1) {
        List<EmbeddedResource> inferred = new HtmlParser().getEmbeddedResources(htmlDocumentUri$1, response$1.body().string(), UserAgent$.MODULE$.getAgent(request$1));
        List<EmbeddedResource> filtered = this.applyResourceFilters(inferred, httpProtocol$1.responsePart().htmlResourcesInferringFilters());
        return this.resourcesToRequests(filtered, session$2, coreComponents$2, httpComponents$2, config$1.throttled());
    }

    public static void $init$(ResourceFetcher $this) {
        $this.io$gatling$http$fetch$ResourceFetcher$_setter_$CssContentCache_$eq(Cache$.MODULE$.newConcurrentCache(((HttpEngine)$this).coreComponents().configuration().http().fetchedCssCacheMaxCapacity()));
        $this.io$gatling$http$fetch$ResourceFetcher$_setter_$InferredResourcesCache_$eq(Cache$.MODULE$.newConcurrentCache(((HttpEngine)$this).coreComponents().configuration().http().fetchedHtmlCacheMaxCapacity()));
    }
}

